/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mock.i18n;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.resourcebundle.DefaultResourceBundle;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.annotation.Nonnull;

public class MockI18nHelper
implements I18nHelper {
    private final Map<String, String> values = new HashMap<String, String>();
    private Locale locale;

    public MockI18nHelper(Locale locale) {
        this.locale = locale;
    }

    public I18nHelper.BeanFactory factory() {
        return new MockI18nHelperFactory();
    }

    public MockI18nHelper() {
    }

    public MockI18nHelper stubWith(String key, String value) {
        this.values.put(key, value);
        return this;
    }

    public boolean hasKey(String key) {
        return this.values.containsKey(key);
    }

    public String getText(String key) {
        return this.getText(key, new Object[0]);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public MockI18nHelper setLocale(Locale locale) {
        this.locale = locale;
        return this;
    }

    public String getUnescapedText(String key) {
        return this.getText(key);
    }

    public String getUntransformedRawText(String key) {
        return this.getText(key);
    }

    public boolean isKeyDefined(String key) {
        return this.values.containsKey(key);
    }

    public String getText(String key, String value1) {
        return this.getText(key, Collections.singletonList(value1));
    }

    public String getText(String key, String value1, String value2, String value3, String value4) {
        return this.getText(key, CollectionBuilder.list((Object[])new String[]{value1, value2, value3, value4}));
    }

    public String getText(String key, String value1, String value2) {
        return this.getText(key, CollectionBuilder.list((Object[])new String[]{value1, value2}));
    }

    public String getText(String key, String value1, String value2, String value3) {
        return this.getText(key, CollectionBuilder.list((Object[])new String[]{value1, value2, value3}));
    }

    public String getText(String key, Object value1, Object value2, Object value3, Object value4, Object value5, Object value6) {
        return this.getText(key, CollectionBuilder.list((Object[])new Object[]{value1, value2, value3, value4, value5, value6}));
    }

    public String getText(String key, String value1, String value2, String value3, String value4, String value5, String value6, String value7) {
        return this.getText(key, CollectionBuilder.list((Object[])new String[]{value1, value2, value3, value4, value5, value6, value7}));
    }

    public String getText(String key, String value1, String value2, String value3, String value4, String value5, String value6, String value7, String value8, String value9) {
        return this.getText(key, CollectionBuilder.list((Object[])new String[]{value1, value2, value3, value4, value5, value6, value7, value8, value9}));
    }

    public String getText(String key, Object value1, Object value2, Object value3) {
        return this.getText(key, CollectionBuilder.list((Object[])new Object[]{value1, value2, value3}));
    }

    public String getText(String key, Object value1, Object value2, Object value3, Object value4) {
        return this.getText(key, CollectionBuilder.list((Object[])new Object[]{value1, value2, value3, value4}));
    }

    public String getText(String key, Object value1, Object value2, Object value3, Object value4, Object value5) {
        return this.getText(key, CollectionBuilder.list((Object[])new Object[]{value1, value2, value3, value4, value5}));
    }

    public String getText(String key, Object value1, Object value2, Object value3, Object value4, Object value5, Object value6, Object value7) {
        return this.getText(key, CollectionBuilder.list((Object[])new Object[]{value1, value2, value3, value4, value5, value6, value7}));
    }

    public String getText(String key, Object value1, Object value2, Object value3, Object value4, Object value5, Object value6, Object value7, Object value8) {
        return this.getText(key, CollectionBuilder.list((Object[])new Object[]{value1, value2, value3, value4, value5, value6, value7, value8}));
    }

    public ResourceBundle getDefaultResourceBundle() {
        return null;
    }

    public String getText(String key, Object parameters) {
        Assertions.notNull((String)"key", (Object)key);
        Object[] params = this.resolveParams(parameters);
        String message = this.values.get(key);
        if (message == null) {
            message = key;
            for (int i = 0; i < params.length; ++i) {
                message = message + " [{" + i + "}]";
            }
        }
        return new MessageFormat(message).format(params);
    }

    private Object[] resolveParams(Object parameters) {
        Object[] params = parameters instanceof List ? ((List)parameters).toArray() : (parameters instanceof Object[] ? (Object[])parameters : new Object[]{parameters});
        return params;
    }

    public Set<String> getKeysForPrefix(String prefix) {
        return null;
    }

    public ResourceBundle getResourceBundle() {
        return DefaultResourceBundle.getDefaultResourceBundle((Locale)this.locale);
    }

    public class MockI18nHelperFactory
    implements I18nHelper.BeanFactory {
        @Nonnull
        public I18nHelper getInstance(Locale locale) {
            return MockI18nHelper.this;
        }

        @Nonnull
        public I18nHelper getInstance(ApplicationUser user) {
            return MockI18nHelper.this;
        }
    }
}

