/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mock.issue.fields.screen.issuetype;

import com.atlassian.jira.issue.fields.screen.FieldScreenScheme;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenScheme;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeEntity;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import org.ofbiz.core.entity.GenericValue;

public class MockIssueTypeScreenScheme
implements IssueTypeScreenScheme {
    private Long id;
    private String name;
    private String description;
    private GenericValue genericValue;
    private Map<String, IssueTypeScreenSchemeEntity> entities = Maps.newHashMap();
    private boolean isDefaultEntity;
    private Collection<GenericValue> projects;

    public MockIssueTypeScreenScheme(Long id, String name, String description) {
        this.id = id;
        this.name = name;
        this.description = description;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public GenericValue getGenericValue() {
        return this.genericValue;
    }

    public void setGenericValue(GenericValue genericValue) {
        this.genericValue = genericValue;
    }

    public void store() {
        throw new UnsupportedOperationException();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public Collection getEntities() {
        return this.entities.values();
    }

    public IssueTypeScreenSchemeEntity getEntity(String issueTypeId) {
        return this.entities.get(issueTypeId);
    }

    @Nonnull
    public FieldScreenScheme getEffectiveFieldScreenScheme(@Nonnull IssueType type) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void addEntity(IssueTypeScreenSchemeEntity issueTypeScreenSchemeEntity) {
        this.entities.put(issueTypeScreenSchemeEntity.getIssueTypeId(), issueTypeScreenSchemeEntity);
    }

    public MockIssueTypeScreenScheme setEntities(Map<String, IssueTypeScreenSchemeEntity> entities) {
        this.entities = entities;
        return this;
    }

    public void removeEntity(String issueTypeId) {
        this.entities.remove(issueTypeId);
    }

    public boolean containsEntity(String issueTypeId) {
        return this.entities.containsKey(issueTypeId);
    }

    public Collection getProjects() {
        return this.projects;
    }

    public MockIssueTypeScreenScheme setProjects(Collection<GenericValue> projects) {
        this.projects = projects;
        return this;
    }

    public boolean isDefault() {
        return this.isDefaultEntity;
    }

    public MockIssueTypeScreenScheme setDefault(boolean isDefaultEntity) {
        this.isDefaultEntity = isDefaultEntity;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MockIssueTypeScreenScheme that = (MockIssueTypeScreenScheme)o;
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }
}

