/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mock.plugin;

import com.atlassian.jira.mock.plugin.MockResources;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.elements.ResourceDescriptor;
import com.atlassian.plugin.elements.ResourceLocation;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.dom4j.Element;

public abstract class MockModuleDescriptor<T>
implements ModuleDescriptor<T> {
    private final Class<T> type;
    private Plugin plugin;
    private String key;
    private MockResources resources = new MockResources();

    public MockModuleDescriptor(Class<T> type, Plugin plugin, String key) {
        this.type = type;
        this.plugin = plugin;
        this.key = key;
    }

    public MockModuleDescriptor(Class<T> type) {
        this(type, null, null);
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setPlugin(Plugin plugin) {
        this.plugin = plugin;
    }

    public String getCompleteKey() {
        return String.format("%s:%s", this.plugin.getKey(), this.key);
    }

    public String getPluginKey() {
        return this.plugin.getKey();
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public String getDescription() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Class<T> getModuleClass() {
        return this.type;
    }

    public void init(@Nonnull Plugin plugin, @Nonnull Element element) {
    }

    public boolean isEnabledByDefault() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean isSystemModule() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void destroy() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Float getMinJavaVersion() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean satisfiesMinJavaVersion() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Map<String, String> getParams() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public String getI18nNameKey() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public String getDescriptionKey() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public List<ResourceDescriptor> getResourceDescriptors() {
        return this.resources.getAll();
    }

    public ResourceDescriptor getResourceDescriptor(String type, String name) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public ResourceLocation getResourceLocation(String type, String name) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public ResourceDescriptor createI18nResource(String name, String location) {
        return this.resources.createI18nResource(name, location);
    }

    public ResourceDescriptor createHelpResource(String name, String location) {
        return this.resources.createHelpResource(name, location);
    }
}

