/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mock.security;

import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.NoopI18nHelper;
import com.atlassian.jira.web.bean.MockI18nBean;
import com.atlassian.jira.web.util.OutlookDate;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nonnull;

public class MockSimpleAuthenticationContext
implements JiraAuthenticationContext {
    private final I18nHelper helper;
    private ApplicationUser user;
    private Locale locale;

    public MockSimpleAuthenticationContext(ApplicationUser user) {
        this(user, Locale.getDefault());
    }

    public MockSimpleAuthenticationContext(ApplicationUser user, Locale locale) {
        this(user, locale, (I18nHelper)new MockI18nBean());
    }

    public MockSimpleAuthenticationContext(ApplicationUser user, Locale locale, @Nonnull I18nHelper helper) {
        this.locale = locale;
        this.helper = Objects.requireNonNull(helper);
        this.setLoggedInUser(user);
    }

    public ApplicationUser getLoggedInUser() {
        return this.user;
    }

    public ApplicationUser getUser() {
        return this.user;
    }

    public boolean isLoggedInUser() {
        return this.getLoggedInUser() != null;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public OutlookDate getOutlookDate() {
        throw new UnsupportedOperationException();
    }

    public String getText(String key) {
        return this.getI18nHelper().getText(key);
    }

    public I18nHelper getI18nHelper() {
        return this.helper;
    }

    public I18nHelper getI18nBean() {
        return this.getI18nHelper();
    }

    public void setLoggedInUser(ApplicationUser user) {
        this.user = user;
    }

    public void clearLoggedInUser() {
        this.user = null;
    }

    public MockSimpleAuthenticationContext setLocale(Locale locale) {
        this.locale = locale;
        return this;
    }

    public static MockSimpleAuthenticationContext createNoopContext(ApplicationUser user) {
        return new MockSimpleAuthenticationContext(user, Locale.ENGLISH, new NoopI18nHelper(Locale.ENGLISH));
    }
}

