/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserLocaleStore;
import com.google.common.collect.Maps;
import java.security.Principal;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;

public class MockUserLocaleStore
implements UserLocaleStore {
    private Locale defaultLocale;
    private final Map<Principal, Locale> data = Maps.newHashMap();

    public MockUserLocaleStore() {
        this(Locale.getDefault());
    }

    public MockUserLocaleStore(Locale defaultLocale) {
        this.defaultLocale = defaultLocale;
    }

    @Nonnull
    public Locale getLocale(ApplicationUser user) {
        return this.getLocaleImpl((Principal)user);
    }

    public MockUserLocaleStore setLocale(Principal user, Locale locale) {
        this.data.put(user, locale);
        return this;
    }

    private Locale getLocaleImpl(Principal user) {
        Locale locale = this.data.get(user);
        return locale == null ? this.getDefaultLocale() : locale;
    }

    @Nonnull
    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }
}

