/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.mock.propertyset.MockPropertySet;
import com.google.common.collect.Maps;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.Map;
import javax.annotation.Nonnull;

public class MockUserPropertyManager
implements UserPropertyManager {
    private final Map<Long, PropertySet> mappingsById = Maps.newHashMap();
    private final Map<String, PropertySet> mappingsByKey = Maps.newHashMap();

    @Nonnull
    public PropertySet getPropertySet(ApplicationUser user) {
        return this.mappingsByKey.get(user.getKey());
    }

    @Nonnull
    public PropertySet getPropertySet(long userId) {
        return this.mappingsById.get(userId);
    }

    @Nonnull
    public PropertySet getPropertySetForUserKey(String userKey) {
        return this.mappingsByKey.get(userKey);
    }

    public PropertySet createOrGetForUser(ApplicationUser user) {
        String userKey = user.getKey();
        PropertySet userProperties = this.mappingsByKey.get(userKey);
        if (userProperties == null) {
            userProperties = new MockPropertySet();
            this.mappingsById.put(user.getId(), userProperties);
            this.mappingsByKey.put(userKey, userProperties);
        }
        return userProperties;
    }
}

