/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow;

import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.workflow.DraftWorkflowSchemeStore;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.ofbiz.core.entity.GenericValue;

class MockDraftWorkflowSchemeState
implements DraftWorkflowSchemeStore.DraftState {
    private Long id;
    private long parentSchemeId;
    private Map<String, String> mappings;
    private Date lastModifiedDate;
    private String lastModifiedUser;

    MockDraftWorkflowSchemeState(DraftWorkflowSchemeStore.DraftState scheme) {
        this.id = scheme.getId();
        this.mappings = Maps.newHashMap((Map)scheme.getMappings());
        this.lastModifiedUser = scheme.getLastModifiedUser();
        this.lastModifiedDate = scheme.getLastModifiedDate();
        this.parentSchemeId = scheme.getParentSchemeId();
    }

    MockDraftWorkflowSchemeState(GenericValue scheme, Iterable<GenericValue> entities) {
        this();
        this.setId(scheme.getLong("id"));
        this.setLastModifiedUser(scheme.getString("lastModifiedUser"));
        Timestamp date = scheme.getTimestamp("lastModifiedDate");
        if (date != null) {
            this.setLastModifiedDate(new Date(date.getTime()));
        }
        this.setParentSchemeId(scheme.getLong("workflowSchemeId"));
        for (GenericValue mapping : entities) {
            String issueType = mapping.getString("issuetype");
            String workflow = mapping.getString("workflow");
            this.setMapping(issueType.equals("0") ? null : issueType, workflow);
        }
    }

    MockDraftWorkflowSchemeState() {
        this.mappings = Maps.newHashMap();
    }

    MockDraftWorkflowSchemeState(Long id, long parentSchemeId, Map<String, String> mappings, Date date, String user) {
        this.id = id;
        this.parentSchemeId = parentSchemeId;
        this.lastModifiedDate = date;
        this.lastModifiedUser = user;
        this.mappings = Maps.newHashMap(mappings);
    }

    MockDraftWorkflowSchemeState setLastModifiedDate(Date date) {
        this.lastModifiedDate = date;
        return this;
    }

    MockDraftWorkflowSchemeState setId(Long id) {
        this.id = id;
        return this;
    }

    MockDraftWorkflowSchemeState setMappings(Map<String, String> issueTypeToWorkflow) {
        this.mappings = Maps.newHashMap(issueTypeToWorkflow);
        return this;
    }

    MockDraftWorkflowSchemeState setParentSchemeId(long parentSchemeId) {
        this.parentSchemeId = parentSchemeId;
        return this;
    }

    MockDraftWorkflowSchemeState setLastModifiedUser(String user) {
        this.lastModifiedUser = user;
        return this;
    }

    MockDraftWorkflowSchemeState setDefaultWorkflow(String workflow) {
        return this.setMapping(null, workflow);
    }

    MockDraftWorkflowSchemeState setMapping(String issueType, String workflow) {
        this.mappings.put(issueType, workflow);
        return this;
    }

    public long getParentSchemeId() {
        return this.parentSchemeId;
    }

    public Long getId() {
        return this.id;
    }

    public Map<String, String> getMappings() {
        return this.mappings;
    }

    public String getDefaultWorkflow() {
        return this.mappings.get(null);
    }

    public Date getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public String getLastModifiedUser() {
        return this.lastModifiedUser;
    }

    public Builder builder() {
        return new Builder(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MockDraftWorkflowSchemeState that = (MockDraftWorkflowSchemeState)o;
        if (this.parentSchemeId != that.parentSchemeId) {
            return false;
        }
        if (this.lastModifiedDate != null ? !this.lastModifiedDate.equals(that.lastModifiedDate) : that.lastModifiedDate != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.mappings != null ? !this.mappings.equals(that.mappings) : that.mappings != null) {
            return false;
        }
        return !(this.lastModifiedUser != null ? !this.lastModifiedUser.equals(that.lastModifiedUser) : that.lastModifiedUser != null);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (int)(this.parentSchemeId ^ this.parentSchemeId >>> 32);
        result = 31 * result + (this.mappings != null ? this.mappings.hashCode() : 0);
        result = 31 * result + (this.lastModifiedDate != null ? this.lastModifiedDate.hashCode() : 0);
        result = 31 * result + (this.lastModifiedUser != null ? this.lastModifiedUser.hashCode() : 0);
        return result;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    static Set<MockDraftWorkflowSchemeState> readSchemes(OfBizDelegator delegator) {
        HashSet result = Sets.newHashSet();
        List all = delegator.findAll("DraftWorkflowScheme");
        for (GenericValue schemeGv : all) {
            Long schemeId = schemeGv.getLong("id");
            List related = delegator.findByAnd("DraftWorkflowSchemeEntity", (Map)ImmutableMap.of((Object)"scheme", (Object)schemeId));
            result.add(new MockDraftWorkflowSchemeState(schemeGv, related));
        }
        return result;
    }

    static Set<MockDraftWorkflowSchemeState> convert(Iterable<DraftWorkflowSchemeStore.DraftState> states) {
        HashSet mockStates = Sets.newHashSet();
        for (DraftWorkflowSchemeStore.DraftState state : states) {
            mockStates.add(new MockDraftWorkflowSchemeState(state));
        }
        return mockStates;
    }

    GenericValue saveSchemeOnlyTo(OfBizDelegator delegator) {
        return delegator.createValue("DraftWorkflowScheme", (Map)this.createSchemeFieldMap());
    }

    MockDraftWorkflowSchemeState saveTo(OfBizDelegator delegator) {
        GenericValue genericValue = this.saveSchemeOnlyTo(delegator);
        for (Map.Entry<String, String> mapping : this.mappings.entrySet()) {
            String issueType = mapping.getKey();
            String workflow = mapping.getValue();
            FieldMap fieldMap = FieldMap.build((String)"scheme", (Object)this.id).add("issuetype", (Object)(issueType == null ? "0" : issueType)).add("workflow", (Object)workflow);
            delegator.createValue("DraftWorkflowSchemeEntity", (Map)fieldMap);
        }
        Timestamp timestamp = genericValue.getTimestamp("lastModifiedDate");
        if (timestamp != null) {
            this.setLastModifiedDate(new Date(timestamp.getTime()));
        } else {
            this.setLastModifiedDate(null);
        }
        return this;
    }

    FieldMap createSchemeFieldMap() {
        FieldMap fieldMap = FieldMap.build((String)"id", (Object)this.id).add("workflowSchemeId", (Object)this.parentSchemeId).add("lastModifiedUser", (Object)this.lastModifiedUser);
        if (this.lastModifiedDate != null) {
            fieldMap.add("lastModifiedDate", (Object)new Timestamp(this.lastModifiedDate.getTime()));
        }
        return fieldMap;
    }

    static class Builder
    implements DraftWorkflowSchemeStore.DraftState.Builder {
        private Long id;
        private String lastModifiedUser;
        private final long parentId;
        private Date lastModifiedDate;
        private Map<String, String> schemeMap;

        public Builder(long parentId) {
            this.parentId = parentId;
            this.schemeMap = Maps.newHashMap();
        }

        public Builder(DraftWorkflowSchemeStore.DraftState state) {
            this.id = state.getId();
            this.parentId = state.getParentSchemeId();
            this.schemeMap = Maps.newHashMap((Map)state.getMappings());
            this.lastModifiedDate = state.getLastModifiedDate();
            this.lastModifiedUser = state.getLastModifiedUser();
        }

        public String getDefaultWorkflow() {
            return this.schemeMap.get(null);
        }

        public Long getId() {
            return this.id;
        }

        public String getDefault() {
            return this.schemeMap.get(null);
        }

        Builder setId(Long id) {
            this.id = id;
            return this;
        }

        public long getParentSchemeId() {
            return this.parentId;
        }

        public Map<String, String> getMappings() {
            return this.schemeMap;
        }

        public Builder setMappings(Map<String, String> mappings) {
            this.schemeMap = Maps.newHashMap(mappings);
            return this;
        }

        public String getLastModifiedUser() {
            return this.lastModifiedUser;
        }

        public DraftWorkflowSchemeStore.DraftState.Builder setLastModifiedUser(String user) {
            this.lastModifiedUser = user;
            return this;
        }

        public Date getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        public MockDraftWorkflowSchemeState build() {
            return new MockDraftWorkflowSchemeState(this.id, this.parentId, this.schemeMap, this.lastModifiedDate, this.lastModifiedUser);
        }

        Builder setLastModifiedDate(Date date) {
            this.lastModifiedDate = date;
            return this;
        }
    }

    static class EntityTable {
        static final String ENTITY = "DraftWorkflowSchemeEntity";

        EntityTable() {
        }

        static class Columns {
            static final String WORKFLOW_SCHEME = "scheme";
            static final String WORKFLOW_NAME = "workflow";
            static final String ISSUE_TYPE = "issuetype";

            Columns() {
            }
        }
    }

    static class SchemeTable {
        static final String ENTITY = "DraftWorkflowScheme";
        static final String ENTITY_RELATIONSHIP = "ChildDraftWorkflowSchemeEntity";

        SchemeTable() {
        }

        static class Columns {
            static final String ID = "id";
            static final String PARENT = "workflowSchemeId";
            static final String UPDATED_DATE = "lastModifiedDate";
            static final String UPDATED_USER = "lastModifiedUser";

            Columns() {
            }
        }
    }
}

