/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.webhooks.anonymize;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.plugins.webhooks.ao.WebhookDao;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.user.anonymize.AffectedEntity;
import com.atlassian.jira.user.anonymize.AffectedEntityType;
import com.atlassian.jira.user.anonymize.UserNameChangeHandler;
import com.atlassian.jira.user.anonymize.UserPropertyChangeParameter;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.webhooks.api.events.WebHookClearListenerCacheEvent;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.java.ao.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateUsernameInWebhookDaoChangeHandler
implements UserNameChangeHandler {
    private static final Logger log = LoggerFactory.getLogger(UpdateUsernameInWebhookDaoChangeHandler.class);
    private final ActiveObjects ao;
    private final I18nResolver i18nResolver;
    private final EventPublisher eventPublisher;

    public UpdateUsernameInWebhookDaoChangeHandler(ActiveObjects ao, I18nResolver i18nResolver, EventPublisher eventPublisher) {
        this.ao = ao;
        this.i18nResolver = i18nResolver;
        this.eventPublisher = eventPublisher;
    }

    @Nonnull
    public Collection<AffectedEntity> getAffectedEntities(@Nonnull UserPropertyChangeParameter parameter) {
        int entitiesCount = this.ao.count(WebhookDao.class, this.getWebhooksForUsernameDaoQuery(parameter.getOriginal()));
        if (entitiesCount > 0) {
            return ImmutableList.of((Object)AffectedEntity.newBuilder((AffectedEntityType)AffectedEntityType.ANONYMIZE).numberOfOccurrences(Long.valueOf(entitiesCount)).descriptionKey("webhook.anonymize.webhook.dao.change.handler.entity").build());
        }
        return ImmutableList.of();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public ServiceResult update(@Nonnull UserPropertyChangeParameter parameter) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        Context.Task task = parameter.getContext().start(null);
        try {
            WebhookDao[] webhooks = this.getWebhooks(parameter);
            this.changeUsernameForWebhooks(errors, webhooks, parameter.getTarget());
            this.eventPublisher.publish((Object)new WebHookClearListenerCacheEvent());
        }
        finally {
            task.complete();
        }
        return new ServiceResultImpl((ErrorCollection)errors);
    }

    public int getNumberOfTasks(@Nonnull UserPropertyChangeParameter userPropertyChangeParameter) {
        return 1;
    }

    @Nonnull
    private Query getWebhooksForUsernameDaoQuery(@Nonnull String username) {
        return Query.select().where("LAST_UPDATED_USER = ?", new Object[]{username});
    }

    @Nonnull
    private WebhookDao[] getWebhooks(@Nonnull UserPropertyChangeParameter parameter) {
        return (WebhookDao[])this.ao.find(WebhookDao.class, this.getWebhooksForUsernameDaoQuery(parameter.getOriginal()));
    }

    @ParametersAreNonnullByDefault
    private void changeUsernameForWebhooks(SimpleErrorCollection errors, WebhookDao[] webhooks, String newUsername) {
        for (WebhookDao webhook : webhooks) {
            try {
                this.changeUsernameForWebhook(webhook, newUsername);
            }
            catch (Exception ex) {
                log.error("An exception occurred during changing Username in WebhookDao", (Throwable)ex);
                errors.addErrorMessage(this.i18nResolver.getText("change.handler.processing.exception", new Serializable[]{ex.getMessage()}));
            }
        }
    }

    @ParametersAreNonnullByDefault
    private void changeUsernameForWebhook(WebhookDao webhook, String newUsername) {
        webhook.setLastUpdatedUser(newUsername);
        webhook.save();
    }
}

