/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.webhooks.serializer;

import com.atlassian.plugins.rest.api.json.JsonMarshallingException;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationIntrospector;

public class JacksonSerializer {
    private static final ObjectMapper JACKSON_JSON_MARSHALLER = new ObjectMapper().findAndRegisterModules().setSerializationInclusion(JsonInclude.Include.NON_NULL).setAnnotationIntrospector(JacksonSerializer.createJacksonJaxbAnnotationIntrospector());

    private JacksonSerializer() {
    }

    public static String serialize(Object object) {
        try {
            return JACKSON_JSON_MARSHALLER.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new JsonMarshallingException((Throwable)e);
        }
    }

    private static AnnotationIntrospector createJacksonJaxbAnnotationIntrospector() {
        JacksonAnnotationIntrospector jacksonIntrospector = new JacksonAnnotationIntrospector();
        JaxbAnnotationIntrospector jaxbIntrospector = new JaxbAnnotationIntrospector(TypeFactory.defaultInstance());
        return AnnotationIntrospector.pair((AnnotationIntrospector)jacksonIntrospector, (AnnotationIntrospector)jaxbIntrospector);
    }
}

