/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.webhooks.url;

import com.atlassian.jira.event.comment.CommentEvent;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.plugins.webhooks.url.IssueAndProjectContextSerializer;
import com.atlassian.webhooks.api.document.ProvidesUrlVariables;
import com.atlassian.webhooks.spi.UriVariablesProvider;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CommentEventVariablesProvider
implements UriVariablesProvider<CommentEvent> {
    private final IssueAndProjectContextSerializer issueAndProjectContextSerializer;

    @Autowired
    public CommentEventVariablesProvider(IssueAndProjectContextSerializer issueAndProjectContextSerializer) {
        this.issueAndProjectContextSerializer = issueAndProjectContextSerializer;
    }

    @ProvidesUrlVariables(value={"project.key", "project.id", "issue.id", "issue.key", "comment.id"})
    public Map<String, Object> uriVariables(CommentEvent commentEvent) {
        Comment comment = commentEvent.getComment();
        Map<String, Object> issueAndProjectContextSerializerContext = this.issueAndProjectContextSerializer.getContext(comment.getIssue().getProjectObject(), comment.getIssue());
        return ImmutableMap.builder().putAll(issueAndProjectContextSerializerContext).put((Object)"comment", (Object)ImmutableMap.of((Object)"id", (Object)comment.getId())).build();
    }
}

