/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.webhooks.workflow;

import com.atlassian.jira.plugin.workflow.AbstractWorkflowPluginFactory;
import com.atlassian.jira.plugin.workflow.WorkflowPluginFunctionFactory;
import com.atlassian.webhooks.api.register.listener.PersistentWebHookListener;
import com.atlassian.webhooks.api.register.listener.WebHookListenerService;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.opensymphony.workflow.loader.AbstractDescriptor;
import com.opensymphony.workflow.loader.FunctionDescriptor;
import io.atlassian.fugue.Option;
import java.util.Map;
import org.apache.log4j.Logger;

public class TriggerWebHookFunctionPluginFactory
extends AbstractWorkflowPluginFactory
implements WorkflowPluginFunctionFactory {
    public static final String PARAM_FIELD_ID = "webhookId";
    public static final String TARGET_FIELD_ID = "field.webhookId";
    public static final String WEBHOOKS = "webhooks";
    public static final String SELECTED_WEBHOOK = "selectedWebhook";
    public static final String WEBHOOK_NAME = "webhookName";
    private static final Logger LOG = Logger.getLogger((String)TriggerWebHookFunctionPluginFactory.class.getName());
    private final WebHookListenerService webHookCustomerService;

    public TriggerWebHookFunctionPluginFactory(WebHookListenerService webHookCustomerService) {
        this.webHookCustomerService = webHookCustomerService;
    }

    protected void getVelocityParamsForInput(Map<String, Object> velocityParams) {
        velocityParams.put(WEBHOOKS, Lists.newArrayList((Iterable)this.webHookCustomerService.getAllWebHookListeners()));
    }

    protected void getVelocityParamsForEdit(Map<String, Object> velocityParams, AbstractDescriptor descriptor) {
        this.getVelocityParamsForInput(velocityParams);
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)descriptor;
        String webHookId = (String)functionDescriptor.getArgs().get(TARGET_FIELD_ID);
        try {
            velocityParams.put(PARAM_FIELD_ID, Integer.parseInt(webHookId));
        }
        catch (NumberFormatException e) {
            LOG.debug((Object)"Webhook id is not a valid integer.", (Throwable)e);
            velocityParams.put(PARAM_FIELD_ID, -1);
        }
    }

    protected void getVelocityParamsForView(Map<String, Object> velocityParams, AbstractDescriptor descriptor) {
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)descriptor;
        String webHookId = (String)functionDescriptor.getArgs().get(TARGET_FIELD_ID);
        try {
            Option webhook = Option.option((Object)this.webHookCustomerService.getWebHookListener(Integer.parseInt(webHookId)).getOrNull());
            if (webhook.isDefined()) {
                velocityParams.put(WEBHOOK_NAME, ((PersistentWebHookListener)webhook.get()).getName());
            }
        }
        catch (NumberFormatException e) {
            LOG.debug((Object)"Webhook id is not a valid integer.", (Throwable)e);
            velocityParams.put(WEBHOOK_NAME, "Webhook not found");
        }
    }

    public Map<String, ?> getDescriptorParams(Map<String, Object> formParams) {
        String webhookId = this.extractSingleParam(formParams, SELECTED_WEBHOOK);
        return ImmutableMap.of((Object)TARGET_FIELD_ID, (Object)webhookId);
    }
}

