/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.webhooks.workflow;

import com.atlassian.jira.plugins.webhooks.workflow.TriggerWebhookFunction;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.FunctionDescriptor;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WorkflowUtil {
    private final WorkflowManager workflowManager;

    @Autowired
    public WorkflowUtil(WorkflowManager workflowManager) {
        this.workflowManager = workflowManager;
    }

    public Set<Map<String, String>> getTransitionLinkedToWebHookListener(int id) {
        HashSet transitions = Sets.newHashSet();
        Collection workflows = this.workflowManager.getWorkflows();
        for (JiraWorkflow workflow : workflows) {
            transitions.addAll(this.getTransitions(id, workflow));
        }
        return transitions;
    }

    private Set<Map<String, String>> getTransitions(int webHookListenerId, JiraWorkflow workflow) {
        HashSet transitions = Sets.newHashSet();
        Map actionToPostfunctionsMap = this.workflowManager.getPostFunctionsForWorkflow(workflow);
        for (Map.Entry entry : actionToPostfunctionsMap.entrySet()) {
            if (!this.isWebHookLinked(webHookListenerId, (Collection)entry.getValue())) continue;
            transitions.add(ImmutableMap.of((Object)"workflow", (Object)workflow.getName(), (Object)"transition", (Object)((ActionDescriptor)entry.getKey()).getName()));
        }
        return transitions;
    }

    private boolean isWebHookLinked(final int id, Collection<FunctionDescriptor> functions) {
        return Iterables.any(functions, (Predicate)new Predicate<FunctionDescriptor>(){

            public boolean apply(FunctionDescriptor functionDescriptor) {
                return this.isTriggerWebHookFunction(functionDescriptor) && this.isWebHookLinkedTo(functionDescriptor);
            }

            private boolean isWebHookLinkedTo(FunctionDescriptor functionDescriptor) {
                return functionDescriptor.getArgs().get("field.webhookId").equals(String.valueOf(id));
            }

            private boolean isTriggerWebHookFunction(FunctionDescriptor functionDescriptor) {
                return TriggerWebhookFunction.class.getName().equals(functionDescriptor.getArgs().get("class.name"));
            }
        });
    }
}

