/* global webhooks */
(function ($) {
    'use strict';

    // This needs to be run immediately and synchronously
    // or we can miss the event webhooks triggers.

    var loaded = new $.Deferred();
    webhooks.onInit(loaded.resolve);

    define('jira-webhooks/init', ['jira-webhooks/entities/transition-collection', 'jira-webhooks/entities/transitions-view', 'jira-webhooks/feature/jql-autocomplete', 'jira/util/formatter', 'jira/moment', 'jquery'], function (TransitionCollection, TransitionsView, webhookJqlAutocomplete, formatter, moment, $) {

        var $jql = null;
        var $jqlDisplay = null;

        loaded.done(function (selectionModel) {
            $jql = $("#webhook-jql").expandOnInput();
            $jqlDisplay = $("#webhook-jql-display");
            var transitionCollection = new TransitionCollection({ "selectionModel": selectionModel });
            new TransitionsView({ model: transitionCollection });
        });

        webhooks.addFilter("issue-related-events-section", function () {
            return $jql.val();
        }, function (filter) {
            $jql.val(filter);
            var trimmedJql = $.trim(filter);
            $jqlDisplay.text(trimmedJql || formatter.I18n.getText('webhooks.admin.jql.empty'));
        });

        webhooks.setDateFormatter(function (date) {
            return moment(date).format('LLL');
        });

        $(function () {
            // eslint-disable-line @atlassian/onready-checks/no-jquery-onready
            webhookJqlAutocomplete.init("#webhook-jql", "#jqlFieldz", "#jqlFunctionNamez", "#jqlReservedWordz");
        });
    });

    require('jira-webhooks/init');
})(window.jQuery);