define('jira-webhooks/feature/jql-autocomplete', ['jira/autocomplete/jql-autocomplete', 'jira/jql/jql-parser', 'jira/util/key-code', 'jquery'], function (JQLAutoComplete, JQLParser, keyCodes, $) {
    'use strict';

    /**
     * @param {jQuery|HTMLElement|String} webhookJql - the element or DOM location to initialise the behaviour
     * @param {jQuery|HTMLElement|String} jqlFieldz
     * @param {jQuery|HTMLElement|String} jqlFunctionNamez
     * @param {jQuery|HTMLElement|String} jqlReservedWordz
     */

    function initWebhooksJqlAutocomplete(webhookJql, jqlFieldz, jqlFunctionNamez, jqlReservedWordz) {
        if (!AJS.params.autocompleteEnabled) {
            return;
        }
        var $advSearch = $(webhookJql);
        var jqlFieldNames = JSON.parse($(jqlFieldz).text());
        var jqlFunctionNames = JSON.parse($(jqlFunctionNamez).text());
        var jqlReservedWords = JSON.parse($(jqlReservedWordz).text());

        var jqlAutoComplete = new JQLAutoComplete({
            fieldID: $advSearch.attr("id"),
            parser: new JQLParser(jqlReservedWords),
            queryDelay: .65,
            jqlFieldNames: jqlFieldNames,
            jqlFunctionNames: jqlFunctionNames,
            minQueryLength: 0,
            allowArrowCarousel: true,
            errorID: 'jqlerrormsg'
        });
        $advSearch.expandOnInput();

        jqlAutoComplete.buildResponseContainer();
        var detachedSuggestionContainer = $('<div class="atlassian-autocomplete webhooks-detached-suggestion-container"/>').append($(jqlAutoComplete.responseContainer).detach()).appendTo("body");
        jqlAutoComplete.parse($advSearch.text());
        jqlAutoComplete.updateColumnLineCount();

        $advSearch.keypress(function (event) {
            if (jqlAutoComplete.dropdownController === null || !jqlAutoComplete.dropdownController.displayed || jqlAutoComplete.selectedIndex < 0) {
                if (event.keyCode === keyCodes.ENTER && !event.ctrlKey && !event.shiftKey) {
                    event.preventDefault();
                    jqlAutoComplete.dropdownController.hideDropdown();
                }
            }
        }).bind('expandedOnInput focus', function () {
            detachedSuggestionContainer.css($advSearch.offset());

            jqlAutoComplete.positionResponseContainer();
        }).bind('webhooks.valueChanged', function () {
            jqlAutoComplete.parse($advSearch.val());
        });
    }

    return {
        init: initWebhooksJqlAutocomplete
    };
});