/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.model.validation;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.util.ErrorCollection;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nullable;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

@ExperimentalApi
public class ErrorCollection {
    private List<ErrorItem> errors = new ArrayList<ErrorItem>();
    private Set<Reason> reasons = new TreeSet<Reason>();
    private static final Map<ErrorCollection.Reason, Reason> jiraToAgileErrorReasonMap = ImmutableMap.builder().put((Object)ErrorCollection.Reason.FORBIDDEN, (Object)Reason.FORBIDDEN).put((Object)ErrorCollection.Reason.NOT_LOGGED_IN, (Object)Reason.FORBIDDEN).put((Object)ErrorCollection.Reason.NOT_FOUND, (Object)Reason.NOT_FOUND).put((Object)ErrorCollection.Reason.SERVER_ERROR, (Object)Reason.SERVER_ERROR).put((Object)ErrorCollection.Reason.VALIDATION_FAILED, (Object)Reason.VALIDATION_FAILED).build();

    public static ErrorCollection fromJiraErrorCollection(com.atlassian.jira.util.ErrorCollection jiraErrors) {
        ErrorCollection errorCollection = new ErrorCollection();
        for (String string : jiraErrors.getErrorMessages()) {
            errorCollection.addContextualError(null, string, new Object[0]);
        }
        for (Map.Entry entry : jiraErrors.getErrors().entrySet()) {
            errorCollection.addContextualError((String)entry.getKey(), (String)entry.getValue(), new Object[0]);
        }
        return errorCollection;
    }

    public static ErrorCollection fromJiraErrorCollectionWithReasons(com.atlassian.jira.util.ErrorCollection jiraErrors) {
        ErrorCollection errorCollection = ErrorCollection.fromJiraErrorCollection(jiraErrors);
        ImmutableSet reasons = ImmutableSet.copyOf((Iterable)Iterables.filter((Iterable)Iterables.transform((Iterable)jiraErrors.getReasons(), (Function)new Function<ErrorCollection.Reason, Reason>(){

            @Nullable
            public Reason apply(ErrorCollection.Reason reason) {
                return (Reason)((Object)jiraToAgileErrorReasonMap.get(reason));
            }
        }), (Predicate)Predicates.notNull()));
        errorCollection.addReasons((Set<Reason>)reasons);
        return errorCollection;
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public boolean hasGlobalErrors() {
        return !this.getGlobalErrors().isEmpty();
    }

    public ErrorCollection addContextualError(String contextId, String messageKey, Object ... params) {
        Preconditions.checkNotNull((Object)messageKey);
        this.errors.add(new ErrorItem(contextId, messageKey, params));
        return this;
    }

    public ErrorCollection addContextualError(Reason reason, String contextId, String messageKey, Object ... params) {
        Preconditions.checkNotNull((Object)messageKey);
        this.reasons.add(reason);
        this.errors.add(new ErrorItem(contextId, messageKey, params));
        return this;
    }

    public ErrorCollection addError(String messageKey, Object ... params) {
        this.addContextualError(null, messageKey, params);
        return this;
    }

    public ErrorCollection addError(Reason reason, String messageKey, Object ... params) {
        this.addReason(reason);
        this.addContextualError(null, messageKey, params);
        return this;
    }

    public List<ErrorItem> getErrors() {
        return this.errors;
    }

    public void clear() {
        this.errors.clear();
    }

    public ErrorCollection addAllErrors(ErrorCollection toAdd) {
        this.reasons.addAll(toAdd.getReasons());
        this.errors.addAll(toAdd.getErrors());
        return this;
    }

    public ErrorCollection addAllErrorsWithoutReason(ErrorCollection toAdd) {
        this.errors.addAll(toAdd.getErrors());
        return this;
    }

    public List<ErrorItem> getContextualErrors(String contextId) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)contextId));
        ArrayList<ErrorItem> items = new ArrayList<ErrorItem>();
        for (ErrorItem item : this.errors) {
            if (!contextId.equals(item.getContextId())) continue;
            items.add(item);
        }
        return items;
    }

    public List<ErrorItem> getGlobalErrors() {
        ArrayList<ErrorItem> items = new ArrayList<ErrorItem>();
        for (ErrorItem item : this.errors) {
            if (item.isContextualError()) continue;
            items.add(item);
        }
        return items;
    }

    public Set<String> getErrorContextIds() {
        HashSet<String> contextIds = new HashSet<String>();
        for (ErrorItem item : this.errors) {
            if (!item.isContextualError()) continue;
            contextIds.add(item.getContextId());
        }
        return contextIds;
    }

    public ErrorCollection addReasons(Set<Reason> reasons) {
        this.reasons.addAll(reasons);
        return this;
    }

    public ErrorCollection addReason(Reason reason) {
        this.reasons.add(reason);
        return this;
    }

    public ErrorCollection setReasons(Set<Reason> reasons) {
        this.reasons = reasons;
        return this;
    }

    public Set<Reason> getReasons() {
        return this.reasons;
    }

    public Reason getDefinitiveReason() {
        if (!this.reasons.isEmpty()) {
            return this.reasons.iterator().next();
        }
        return null;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public static class ErrorItem {
        private String contextId;
        private String messageKey;
        private Object[] params;

        public ErrorItem(String contextId, String messageKey, Object ... params) {
            this.contextId = contextId;
            this.messageKey = messageKey;
            this.params = params;
        }

        public String getContextId() {
            return this.contextId;
        }

        public void setContextId(String contextId) {
            this.contextId = contextId;
        }

        public String getMessageKey() {
            return this.messageKey;
        }

        public void setMessageKey(String messageKey) {
            this.messageKey = messageKey;
        }

        public Object[] getParams() {
            return this.params;
        }

        public void setParams(Object[] params) {
            this.params = params;
        }

        public boolean isContextualError() {
            return this.contextId != null && this.contextId.length() > 0;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }

    public static enum Reason {
        SERVER_ERROR(Response.Status.INTERNAL_SERVER_ERROR),
        FORBIDDEN(Response.Status.FORBIDDEN),
        NOT_FOUND(Response.Status.NOT_FOUND),
        VALIDATION_FAILED(Response.Status.BAD_REQUEST),
        CONFLICT(Response.Status.CONFLICT);

        public final Response.Status mappedStatus;

        private Reason(Response.Status mappedStatus) {
            this.mappedStatus = mappedStatus;
        }
    }
}

