/* globals ok, AgileDashboardItem, module, sinon, equal, test */
AJS.test.require(["com.pyxis.greenhopper.jira:gh-test-common",
                  "com.pyxis.greenhopper.jira:dashboard-item-common-test-resources",
                  "com.pyxis.greenhopper.jira:greenhopper-days-remaining-dashboard-item-resources"],
    function() {

        var SprintDaysRemainingDashboardItem;

        //  Run tests only for JIRA 6.4+
        try {
            SprintDaysRemainingDashboardItem = require('jira-dashboard-items/sprint-days-remaining');
        } catch(err){
            console.log("Run tests only for JIRA 6.4+, erorr thrown:", err.message);
        }

        module('sprint days remaining dashboard item tests', {

            setup: function () {

                this.server = sinon.fakeServer.create();

                var API = AJS.$.extend({}, AgileDashboardItem.Mocks.API);

                if (SprintDaysRemainingDashboardItem) {
                    this.dashboardItem = new SprintDaysRemainingDashboardItem(API);
                    this.element = AJS.$("<div/>");
                    this.element.append(GH.tpl.dashboardItems.sprintDaysRemaining.wrapper());
                }

            },

            teardown: function () {
                this.server.restore();
            }

        });


        if(typeof SprintDaysRemainingDashboardItem !== 'undefined') {

            var MOCK_BOARD_TYPES = {
                views : [
                    {
                        name: "Mock Board 1",
                        id: 1,
                        sprintSupportEnabled: true
                    },
                    {
                        name: "Mock Board 2",
                        id: 2,
                        sprintSupportEnabled: true
                    },
                    {
                        name: "Mock Board 3",
                        id: 3,
                        sprintSupportEnabled: false
                    },
                    {
                        name: "Mock Board 4",
                        id: 4,
                        sprintSupportEnabled: false
                    },
                    {
                        name: "Mock Board 5",
                        id: 5,
                        sprintSupportEnabled: false
                    }
                ]
            };

            var MOCK_BOARD_DATA = {
                currentViewConfig: AJS.$.extend({}, MOCK_BOARD_TYPES.views[0])
            };

            var MOCK_SPRINT_TYPES_ONE = {
                sprints : [
                    {
                        name: "Mock Sprint 1.1",
                        id: 1,
                        state: "ACTIVE"
                    },
                    {
                        name: "Mock Sprint 1.2",
                        id: 2,
                        state: "ACTIVE"
                    },
                    {
                        name: "Mock Sprint 1.3",
                        id: 3,
                        state: "ACTIVE"
                    }
                ]
            };

            var MOCK_SPRINT_TYPES_TWO = {
                sprints : [
                    {
                        name: "Mock Sprint 2.1",
                        id: 1,
                        state: "ACTIVE"
                    },
                    {
                        name: "Mock Sprint 2.2",
                        id: 2,
                        state: "ACTIVE"
                    }
                ]
            };

            var MOCK_SPRINT_DAYS_REMAINING_DATA = {
                "name": "Mock Sprint 1.1",
                "id": 1,
                "timeRemaining" : {
                    days: 50
                }
            };

            var MOCK_PREFERENCES = {
                isConfigured: true,
                rapidViewId: "1",
                refresh: false,
                showRapidViewName: true,
                showSprintName: true,
                sprintId: "2"
            };

            var CHANGE_PREFERENCES = AJS.$.extend({}, MOCK_PREFERENCES, {
                rapidViewId: "2",
                sprintId: "1"
            });

            test("Testing error message being shown if configuration has not already been set on render", function() {
                var element = this.element;
                var preferences = {
                    isConfigured: false
                };

                this.dashboardItem.sprintDaysRemainingView.setElement(element);
                this.dashboardItem.render(element, preferences);

                var errorMessage = element.find(".aui-message");

                ok(errorMessage.length > 0, 'Found the error message within the div.');
            });

            test("Testing error message being shown if user doesn't has software license", function() {
                var element = this.element;
                var preferences = MOCK_PREFERENCES;

                this.dashboardItem.render(element, preferences);
                this.server.requests[0].respond(403, { "Content-Type": "application/json" });

                var errorMessage = element.find(".aui-message");

                ok(errorMessage.length > 0, 'Found the error message within the div.');
            });

            test("Testing if the board types are populated correctly", function(){

                var element = this.element;
                var preferences = {};

                this.dashboardItem.renderEdit(element, preferences);
                this.server.requests[0].respond(200, { "Content-Type": "application/json" }, JSON.stringify(MOCK_BOARD_TYPES));

                var allOptions = element.find("select[name=board-type] option");
                var optionOne = element.find("select[name=board-type] option:eq(0)").text();
                var optionTwo = element.find("select[name=board-type] option:eq(1)").text();

                equal(allOptions.length, 2, "The correct number of board types have been rendered/selected.");
                equal(optionOne, "Mock Board 1", "Options rendered correctly - option one has been mocked correctly.");
                equal(optionTwo, "Mock Board 2", "Options rendered correctly - option two has been mocked correctly.");

            });

            test("Testing if sprint types are populated correctly", function(){

                var element = this.element;
                var preferences = {};

                var allSprintOptions, optionOne, optionTwo, optionThree, optionFour;

                this.dashboardItem.renderEdit(element, preferences);
                this.server.requests[0].respond(200, { "Content-Type": "application/json" }, JSON.stringify(MOCK_BOARD_TYPES));

                var sprintPicker = element.find("select[name=sprint-type]");
                var boardPicker = element.find("select[name=board-type]");

                sprintPicker.find("option:eq(0)").prop("selected", true);

                this.server.requests[1].respond(200, { "Content-Type": "application/json" }, JSON.stringify(MOCK_SPRINT_TYPES_ONE));

                allSprintOptions = sprintPicker.find("option");
                optionOne = sprintPicker.find("option:eq(0)").text();
                optionTwo = sprintPicker.find("option:eq(1)").text();
                optionThree = sprintPicker.find("option:eq(2)").text();
                optionFour = sprintPicker.find("option:eq(3)").text();

                equal(allSprintOptions.length, 4, "The correct number of sprints have been rendered/selected for Mock Board 1.");
                equal(optionOne, "gh.gadget.sprint.option.auto", "Options rendered correctly - auto sprint option has been mocked correctly.");
                equal(optionTwo, "Mock Sprint 1.1", "Options rendered correctly - option one has been mocked correctly.");
                equal(optionThree, "Mock Sprint 1.2", "Options rendered correctly - option two has been mocked correctly.");
                equal(optionFour, "Mock Sprint 1.3", "Options rendered correctly - option three has been mocked correctly.");

                boardPicker.find("option:eq(1)").prop("selected", true);
                boardPicker.trigger("change");

                this.server.requests[2].respond(200, { "Content-Type": "application/json" }, JSON.stringify(MOCK_SPRINT_TYPES_TWO));

                allSprintOptions = element.find("select[name=sprint-type] option");
                optionOne = element.find("select[name=sprint-type] option:eq(0)").text();
                optionTwo = element.find("select[name=sprint-type] option:eq(1)").text();
                optionThree = element.find("select[name=sprint-type] option:eq(2)").text();

                equal(allSprintOptions.length, 3, "The correct number of sprints have been rendered/selected for Mock Board 2.");
                equal(optionOne, "gh.gadget.sprint.option.auto", "Options rendered correctly - auto sprint option has been mocked correctly.");
                equal(optionTwo, "Mock Sprint 2.1", "Options rendered correctly - option one has been mocked correctly.");
                equal(optionThree, "Mock Sprint 2.2", "Options rendered correctly - option two has been mocked correctly.");

            });

            test("Testing preferences are being saved and applied when form is submitted", function(){
                var element = this.element;
                var preferences = MOCK_PREFERENCES;
                var savePreferencesSpy = sinon.spy();
                sinon.stub(this.dashboardItem.API, "savePreferences", savePreferencesSpy);

                //  Will render edit mode with mock params.
                this.dashboardItem.renderEdit(element, preferences);
                this.server.requests[0].respond(200, { "Content-Type": "application/json" }, JSON.stringify(MOCK_BOARD_TYPES));

                //  Now introduce some changes to these params (change rapidViewId to 2, and sprintId to 1).
                var expectedPreferences = AJS.$.extend({}, preferences, CHANGE_PREFERENCES);

                //  Reflect these changes in the DOM.
                var form = element.find("form");
                var sprintPicker = element.find("select[name=sprint-type]");
                var boardPicker = element.find("select[name=board-type]");

                boardPicker.find("option:eq(1)").prop("selected", true);
                boardPicker.trigger("change");

                this.server.requests[1].respond(200, { "Content-Type": "application/json" }, JSON.stringify(MOCK_SPRINT_TYPES_TWO));

                sprintPicker.find("option:eq(1)").prop("selected", true);
                form.trigger("submit");

                //  Check if the preferences have been saved (they should be).
                ok(savePreferencesSpy.calledOnce, "Preferences have been saved.");

                //  Update the preferences object to reflect the state of the config view in the DOM.
                preferences = AJS.$.extend({}, preferences, {
                    rapidViewId: boardPicker.find("option:selected").val(),
                    sprintId: sprintPicker.find("option:selected").val()
                });

                //  Test passes if the preferences object has been successfully updated.
                deepEqual(preferences, expectedPreferences, "Preferences correctly changed.");

            });

            test("Testing boolean checkboxes and hiding/showing of names", function(){

                var element = this.element;

                //  Set up a preferences object where showSprintName = true, showRapidViewName = false.
                var mixedShowPreferences = AJS.$.extend({}, MOCK_PREFERENCES, {
                    showRapidViewName : false
                });

                this.dashboardItem.render(element, mixedShowPreferences);

                this.server.requests[0].respond(200, { "Content-Type": "application/json" }, JSON.stringify(MOCK_SPRINT_DAYS_REMAINING_DATA));
                this.server.requests[1].respond(200, { "Content-Type": "application/json" }, JSON.stringify(MOCK_BOARD_DATA));

                //  Search the DOM for the three elements.
                var showRapidViewName = element.find("h2.gg-name").length > 0;
                var showSprintName = element.find("h3.gg-subtitle").length > 0;

                console.log(element.find("h2.gg-name"));
                console.log(showSprintName, showRapidViewName);

                equal(showSprintName, true, "showSprintName bool correctly set.");
                equal(showRapidViewName, false, "showRapidViewName bool correctly set.");

            });

            test("Testing if days remaining metric is correct", function(){
                var element = this.element;
                var preferences = MOCK_PREFERENCES;

                this.dashboardItem.render(element, preferences);

                this.server.requests[0].respond(200, { "Content-Type": "application/json" }, JSON.stringify(MOCK_SPRINT_DAYS_REMAINING_DATA));
                this.server.requests[1].respond(200, { "Content-Type": "application/json" }, JSON.stringify(MOCK_BOARD_DATA));

                //  Get the metric
                var daysRemainingMetric = parseInt(element.find(".ghx-remaining-value").text());

                equal(daysRemainingMetric, 50, "Days Remaining Metric is correct.");

            });

            test("Testing gadget auto refresh", function () {

                this.stub(this.dashboardItem.API, "initRefresh");

                var element = this.element;
                var preferences = MOCK_PREFERENCES;

                this.dashboardItem.render(element, preferences);
                ok(this.dashboardItem.API.initRefresh.called, "Gadget should call initRefresh()");

            });

            test('refresh in preferences should be false in case auto-refresh unchecked', function(){
                var element = this.element;

                //  Render edit mode with mock params
                this.dashboardItem.renderEdit(element, MOCK_PREFERENCES);
                this.server.requests[0].respond(200, { 'Content-Type': 'application/json' }, JSON.stringify(MOCK_BOARD_TYPES));

                AJS.$(this.dashboardItem.sprintDaysRemainingView).on('submit', function(e, preferences) {
                    ok(preferences.refresh === false);
                });
                element.find('form').trigger('submit');
            });
        } else {

            test("Make test pass in JIRA <6.4", function(){
                ok(true);
            });

        }
    }
);
