/**
 * Simple JS for toggling configuration features
 */
require(['jquery', 'wrm/context-path'], function (jQuery, wrmContextPath) {
    var toggleFeature = function toggleFeature(clickEvent) {
        var input = clickEvent.target;
        var featureId = input.id;
        var newValue = input.checked;
        var url = wrmContextPath() + '/secure/SetFeatureEnabled.jspa';

        jQuery.ajax({
            url: url,
            type: 'POST',
            data: { featureId: featureId, newValue: newValue }
        });
    };

    var initialiseEvents = function initialiseEvents() {
        return jQuery('.software-feature input').on('click', toggleFeature);
    };

    jQuery(initialiseEvents);
});