define('jira-agile/admin/lexorank/views/lexorank-management-balance-view', ['require'], function (require) {
    var Backbone = require('backbone');
    var _ = require('underscore');
    var jQuery = require('jquery');
    var wrmContextPath = require('wrm/context-path');
    var AuiMessages = require('aui/message');
    var UiUtils = GH.Util.UI;

    return Backbone.View.extend({
        events: {
            'click .js-lrmng-balance-refresh-button': 'refreshBalanceStatus',
            'click .js-lrmng-balance-all-fields-button': 'balanceAllFields',
            'click .js-lrmng-balance-field-button': 'balanceField'
        },

        initialize: function initialize(options) {
            _.extend(this, _.pick(options, 'service'));
            this.model.on('change:balanceStatus', this.render, this);
            this.model.on('change:balanceMessage', this.displayMessage, this);
            this.model.on('change:balanceStatusInProgress', this.enableControls, this);
        },
        render: function render() {
            var lexorankStatus = this.model.get('balanceStatus');
            this.$el.html(GH.tpl.lexorankmanagement.renderBalanceStatus({
                lexorankStatus: lexorankStatus,
                baseUrl: wrmContextPath()
            }));
            this.enableControls();
        },
        displayMessage: function displayMessage() {
            var message = this.model.get('balanceMessage');
            if (message && message.error) {
                AuiMessages.error('#js-lrmng-balance-message', {
                    body: message.error,
                    fadeout: true
                });
            } else if (message && message.success) {
                AuiMessages.success('#js-lrmng-balance-message', {
                    body: message.success,
                    fadeout: true
                });
            }
        },
        refreshBalanceStatus: function refreshBalanceStatus() {
            this.service.refreshBalanceStatus();
        },
        balanceAllFields: function balanceAllFields() {
            this.service.requestBalanceAll();
        },
        balanceField: function balanceField(event) {
            var fieldId = jQuery(event.target).attr('data-button');
            this.service.requestBalanceField(fieldId);
        },
        enableControls: function enableControls() {
            if (this.model.get('balanceStatusInProgress')) {
                UiUtils.ariaDisable('.js-lrmng-balance-refresh-button');
                UiUtils.ariaDisable('.js-lrmng-balance-all-fields-button');
                UiUtils.ariaDisable('.js-lrmng-balance-field-button');
            } else {
                UiUtils.ariaEnable('.js-lrmng-balance-refresh-button');
                UiUtils.ariaEnable('.js-lrmng-balance-all-fields-button');
                UiUtils.ariaEnable('.js-lrmng-balance-field-button');
            }
        }
    });
});

AJS.namespace('GH.LexoRankManagementBalanceView', null, require('jira-agile/admin/lexorank/views/lexorank-management-balance-view'));