define('jira-agile/admin/lexorank/views/lexorank-management-integrity-view', ['require'], function (require) {
    var _ = require('underscore');
    var Backbone = require('backbone');
    var AuiMessages = require('aui/message');
    var UiUtils = GH.Util.UI;

    return Backbone.View.extend({
        events: {
            'click .js-lrmng-integrity-run-button': 'runIntegrity'
        },

        initialize: function initialize(options) {
            _.extend(this, _.pick(options, 'service'));
            this.model.on('change:integrityCheck', this.render, this);
            this.model.on('change:integrityMessage', this.displayMessage, this);
            this.model.on('change:integrityCheckInProgress', this.enableControls, this);
        },
        render: function render() {
            var integrityResult = this.model.get('integrityCheck');
            this.$el.html(GH.tpl.lexorankmanagement.renderIntegrityResult({ integrityResult: integrityResult }));
            this.enableControls();
        },
        runIntegrity: function runIntegrity() {
            this.service.runIntegrity();
        },
        displayMessage: function displayMessage() {
            var message = this.model.get('integrityMessage');
            if (message && message.error) {
                AuiMessages.error('#js-lrmng-integrity-message', {
                    body: message.error,
                    fadeout: true
                });
            } else if (message && message.success) {
                AuiMessages.success('#js-lrmng-integrity-message', {
                    body: message.success,
                    fadeout: true
                });
            }
            this.model.unset('integrityMessage');
        },
        enableControls: function enableControls() {
            if (this.model.get('integrityCheckInProgress')) {
                UiUtils.ariaDisable('.js-lrmng-integrity-run-button');
            } else {
                UiUtils.ariaEnable('.js-lrmng-integrity-run-button');
            }
        }
    });
});

AJS.namespace('GH.LexoRankManagementIntegrityView', null, require('jira-agile/admin/lexorank/views/lexorank-management-integrity-view'));