/* global Boards */

AJS.namespace("GH.Dialog");

GH.Dialog.baseExtension = {
    _getDefaultOptions: function () {
        return AJS.$.extend(this._super(), {
            /**
             * Original defined in formpopup.js
             * The original version reloads the page, we though want to hide the dialog and update the ui instead
             */
            onDialogFinished: function () {
                // Ignore the redirect (set by some actions, such as clone or delete), and the reload too.
                // ORIG CODE BEGIN
                /*
                 // Always close the dialog before attempting to unload the page, in case
                 // dirty-form or some other onunload check blocks it. Be sure to get the target first,
                 // though, because it's stored in the dialog's DOM and is lost when the dialog is hidden.
                 var targetUrl = this._getTargetUrlValue();

                 this.hide();

                 if (targetUrl) {
                 AJS.$(AJS).trigger('page-unload.location-change.from-dialog', [this.$popup]);
                 window.location.href = targetUrl;
                 } else {
                 AJS.$(AJS).trigger('page-unload.refresh.from-dialog', [this.$popup]);
                 AJS.reloadViaWindowLocation(window.location.href);
                 }
                 */
                // ORIG CODE END
                this.handleSuccess();
            }
        });
    },

    /**
     * Overwrite _performRedirect to call handleSuccess instead
     */
    _performRedirect: function () {
        this.redirected = true;
        this.handleSuccess();
    },

    /**
     * Overwrite hide() to call doCancelCleanup
     *
     * handleCancel() isn't called when the cancel link is clicked, only when esc is used!
     * By overwriting hide we are at least sure we get always called
     */
    hide: function (undim, options) {
        // don't do anything if we are not the current popup
        if (JIRA.Dialog.current !== this) {
            return false;
        }

        // call orig implementation
        this._super(undim);

        // callback in case this is a cancel hide
        // options is only populated for esc/cancel currently, while true means success
        if (options !== true && options && (options.reason === JIRA.Dialog.HIDE_REASON.escape || options.reason === JIRA.Dialog.HIDE_REASON.cancel)) {
            this.doCancelCleanup();
        }
    },

    doCancelCleanup: function () {
    },

    handleSuccess: function () {
    }

};
