require(['require'], function (require) {
    var $ = require('jquery');
    var _ = require('underscore');

    function extractProjectKeysFromCurrentJql(currentJql) {
        if (currentJql.indexOf("project") !== 0) {
            return "";
        }
        return extractSelectedProjectKeysFromJql(currentJql).trim();
    }

    function extractSelectedProjectKeysFromJql(jql) {
        function extractForEqualsOperator(jql) {
            var matches = jql.match(/\bproject\s*=\s*(\S+)/i);
            return matches ? matches[1] : null;
        }

        function extractForInOperator(jql) {
            var matches = jql.match(/\bproject\s+in\s+\((.*?)\)/i);
            return matches ? matches[1] : null;
        }

        return extractForEqualsOperator(jql) || extractForInOperator(jql);
    }

    JIRA.bind(JIRA.Events.NEW_CONTENT_ADDED, function (e, $ctx) {
        var currentJQL = $("#jql", this).val();
        $ctx.find(".js-epiclink-checkboxmultiselect").each(function () {
            var multiSelect = new AJS.CheckboxMultiSelect({
                element: this,
                matchingStrategy: "(^|.*?(.*))({0})(.*)", // Matches any characters within any words, regardless starting words.
                maxInlineResultsDisplayed: 5,
                content: "ajax",
                removeOnUnSelect: true,
                ajaxOptions: {
                    url: AJS.contextPath() + "/rest/greenhopper/1.0/epics",
                    error: function () {
                        multiSelect._setSuggestions([]);
                    },
                    data: {
                        searchQuery: "", //intentionally left empty in order to use default param, which is "query", for searchTerm instead.
                        projectKey: extractProjectKeysFromCurrentJql(currentJQL),
                        filterEpicsByGivenProjects: true,
                        maxResults: 100
                    },
                    query: true,
                    minQueryLength: 0,
                    formatResponse: function (response) {
                        var ret = [];
                        ret.push(new AJS.GroupDescriptor({
                            weight: 1,
                            items: [new AJS.ItemDescriptor({
                                highlighted: true,
                                label: AJS.I18n.getText("gh.epic.link.searcher.special.option"),
                                value: "EMPTY",
                                title: "EMPTY"
                            })]
                        }));

                        if (!response || !response.epicLists || response.total === 0) {
                            return ret;
                        }

                        for (var i = 0; i < response.epicLists.length; i++) {
                            var epicList = response.epicLists[i];
                            var epicNames = epicList.epicNames;
                            var groupDescriptor = new AJS.GroupDescriptor({
                                label: epicList.listDescriptor,
                                weight: i
                            });

                            if (epicNames.length > 0) {
                                _.each(epicNames, function (epic) {
                                    groupDescriptor.addItem(new AJS.ItemDescriptor({
                                        highlighted: true,
                                        label: epic.name + ' - (' + epic.key + ')',
                                        value: epic.key,
                                        title: epic.key
                                    }));
                                });
                                ret.push(groupDescriptor);
                            }
                        }
                        return ret;
                    }
                },
                suggestionsHandler: GH.EpicLinkSuggestHandler
            });
        });
    });
});
