/**
 * Plot an array of points as a stacked bar, with optional labels centered in bar
 */
c3.stack = function () {
    return c3.component('stack')
        .extend(c3.floatingBarChart())
        .elementTag('g')
        .xAccessor(function () {
            return 0;
        })
        .extend({
            classPrefix: c3.prop(),
            labelAccessor: function () {
                return this.yAccessor();
            },
            labelFormatter: function () {
                return d3.format(',d');
            }
        })
        .enter(function (event) {
            var classPrefix = this.classPrefix();
            event.selection.insert('rect', ':first-child')
                .attr('class', function (d, i) {
                    return classPrefix + '-series-' + i;
                });
        })
        .update(function (event) {
            var classPrefix = this.classPrefix();
            var barHeight = this.barHeight();
            var barWidth = this.barWidth();

            event.selection.select('rect')
                .attr('height', barHeight)
                .attr('width', barWidth);

            if (this.showLabels()) {
                event.selection.select('text')
                    .attr('dy', '0.45em')
                    .attr('y', function (d) {
                        return barHeight(d) / 2;
                    })
                    .attr('class', function (d, i) {
                        return classPrefix + '-series-label-' + i;
                    })
                    .classed('bar-label', true)
                    .text(this.labelAccessor())
                    .call(c3.utils.containText, function() { return barWidth; }, barHeight);
            }
        });
};