AJS.test.require(["com.pyxis.greenhopper.jira:gh-test-common", "com.pyxis.greenhopper.jira:gh-rapid-common"], function() {
    var AnalyticsTracker = require('jira-agile/rapid/analytics-tracker');

    module("AnalyticsTracker", {
        setup: function() {
            sinon.stub(AJS, "$").returns(AJS.$);
            AJS.$.trigger = sinon.spy();
        },
        teardown: function() {
            AJS.$.restore();
        }
    });

    test('AnalyticsTracker module exists and global variable is also exposed', function () {
        ok(AnalyticsTracker);
        ok(GH.AnalyticsTracker);
    });

    test('AnalyticsTracker zero arg constructor', function() {
        var thrown = false;
        try {
            new AnalyticsTracker();
        } catch (expected) {
            thrown = true;
        }

        ok(thrown, "Should have blown up when constructing tracker with no arguments");
    });

    test('uses constructor arg as category', function() {
        var at = new AnalyticsTracker('myCat');
        at.trigger();

        ok(AJS.$.trigger.calledOnce);
        var params = AJS.$.trigger.getCall(0).args[1];

        equal(params.category, "myCat");
        equal(params.action, "");
        equal(params.label, "");
    });

    test('uses constructor arg as category and trigger arg as action', function() {
        var at = new AnalyticsTracker('myCat');
        at.trigger("myAct");

        ok(AJS.$.trigger.calledOnce);
        var params = AJS.$.trigger.getCall(0).args[1];

        equal(params.category, "myCat");
        equal(params.action, "myAct");
        equal(params.label, "");
    });

    test('uses constructor arg as category and trigger args as action and label', function() {
        var at = new AnalyticsTracker('myCat');
        at.trigger("myAct", "myLab");

        ok(AJS.$.trigger.calledOnce);
        var params = AJS.$.trigger.getCall(0).args[1];

        equal(params.category, "myCat");
        equal(params.action, "myAct");
        equal(params.label, "myLab");
    });

    test('uses constructor arg as category and trigger args as action, label and value', function() {
        var at = new AnalyticsTracker('myCat');
        at.trigger("myAct", "myLab", 5);

        ok(AJS.$.trigger.calledOnce);
        var params = AJS.$.trigger.getCall(0).args[1];

        equal(params.category, "myCat");
        equal(params.action, "myAct");
        equal(params.label, "myLab");
        equal(params.value, 5);
    });

    test('rounds decimal value', function() {
        var at = new AnalyticsTracker('myCat');
        at.trigger("myAct", "myLab", 5.2);

        ok(AJS.$.trigger.calledOnce);
        var params = AJS.$.trigger.getCall(0).args[1];

        equal(params.category, "myCat");
        equal(params.action, "myAct");
        equal(params.label, "myLab");
        equal(params.value, 5);
    });

    test('turns string value into number', function() {
        var at = new AnalyticsTracker('myCat');
        at.trigger("myAct", "myLab", "5");

        ok(AJS.$.trigger.calledOnce);
        var params = AJS.$.trigger.getCall(0).args[1];

        equal(params.category, "myCat");
        equal(params.action, "myAct");
        equal(params.label, "myLab");
        equal(params.value, 5);
    });

    test('ignores value if not a number', function() {
        var at = new AnalyticsTracker('myCat');
        at.trigger("myAct", "myLab", "x");

        ok(AJS.$.trigger.calledOnce);
        var params = AJS.$.trigger.getCall(0).args[1];

        equal(params.category, "myCat");
        equal(params.action, "myAct");
        equal(params.label, "myLab");
        equal(params.value, undefined);
    });

    test('ignores additional arguments', function() {
        var at = new AnalyticsTracker('myCat');
        at.trigger("myAct", "myLab", 5, 6);

        ok(AJS.$.trigger.calledOnce);
        var params = AJS.$.trigger.getCall(0).args[1];

        equal(params.category, "myCat");
        equal(params.action, "myAct");
        equal(params.label, "myLab");
        equal(params.value, 5);
    });

    test("uses second constructor arg as action", function() {
        var at = new AnalyticsTracker('myCat', 'myAct');
        at.trigger();

        ok(AJS.$.trigger.calledOnce);
        var params = AJS.$.trigger.getCall(0).args[1];

        equal(params.category, "myCat");
        equal(params.action, "myAct");
        equal(params.label, "");
        equal(params.value, undefined);
    });

    test("uses second constructor arg as action and trigger arg as label", function() {
        var at = new AnalyticsTracker('myCat', 'myAct');
        at.trigger("myLab");

        ok(AJS.$.trigger.calledOnce);
        var params = AJS.$.trigger.getCall(0).args[1];

        equal(params.category, "myCat");
        equal(params.action, "myAct");
        equal(params.label, "myLab");
        equal(params.value, undefined);
    });

    test("uses second constructor arg as action and trigger args as label and value", function() {
        var at = new AnalyticsTracker('myCat', 'myAct');
        at.trigger("myLab", 5);

        ok(AJS.$.trigger.calledOnce);
        var params = AJS.$.trigger.getCall(0).args[1];

        equal(params.category, "myCat");
        equal(params.action, "myAct");
        equal(params.label, "myLab");
        equal(params.value, 5);
    });

    test("rounds value with two constructor args", function() {
        var at = new AnalyticsTracker('myCat', 'myAct');
        at.trigger("myLab", 5.2);

        ok(AJS.$.trigger.calledOnce);
        var params = AJS.$.trigger.getCall(0).args[1];

        equal(params.category, "myCat");
        equal(params.action, "myAct");
        equal(params.label, "myLab");
        equal(params.value, 5);
    });

    test("makes string value an integer with two constructor args", function() {
        var at = new AnalyticsTracker('myCat', 'myAct');
        at.trigger("myLab", "5");

        ok(AJS.$.trigger.calledOnce);
        var params = AJS.$.trigger.getCall(0).args[1];

        equal(params.category, "myCat");
        equal(params.action, "myAct");
        equal(params.label, "myLab");
        equal(params.value, 5);
    });

    test("ignores NaN value with two constructor args", function() {
        var at = new AnalyticsTracker('myCat', 'myAct');
        at.trigger("myLab", "x");

        ok(AJS.$.trigger.calledOnce);
        var params = AJS.$.trigger.getCall(0).args[1];

        equal(params.category, "myCat");
        equal(params.action, "myAct");
        equal(params.label, "myLab");
        equal(params.value, undefined);
    });

    test("ignores subsequent args with two constructor args", function() {
        var at = new AnalyticsTracker('myCat', 'myAct');
        at.trigger("myLab", 5, 88);

        ok(AJS.$.trigger.calledOnce);
        var params = AJS.$.trigger.getCall(0).args[1];

        equal(params.category, "myCat");
        equal(params.action, "myAct");
        equal(params.label, "myLab");
        equal(params.value, 5);
    });

    test('uses third constructor arg as label', function() {
        var at = new AnalyticsTracker('myCat', 'myAct', 'myLab');
        at.trigger();

        ok(AJS.$.trigger.calledOnce);
        var params = AJS.$.trigger.getCall(0).args[1];

        equal(params.category, "myCat");
        equal(params.action, "myAct");
        equal(params.label, "myLab");
        equal(params.value, undefined);

    });

    test('uses trigger arg as value with three constructor args', function() {
        var at = new AnalyticsTracker('myCat', 'myAct', 'myLab');
        at.trigger(6);

        ok(AJS.$.trigger.calledOnce);
        var params = AJS.$.trigger.getCall(0).args[1];

        equal(params.category, "myCat");
        equal(params.action, "myAct");
        equal(params.label, "myLab");
        equal(params.value, 6);

    });

    test('rounds decimal for value with three constructor args', function() {
        var at = new AnalyticsTracker('myCat', 'myAct', 'myLab');
        at.trigger(6.5);

        ok(AJS.$.trigger.calledOnce);
        var params = AJS.$.trigger.getCall(0).args[1];

        equal(params.category, "myCat");
        equal(params.action, "myAct");
        equal(params.label, "myLab");
        equal(params.value, 6);

    });

    test('makes string into number for value with three constructor args', function() {
        var at = new AnalyticsTracker('myCat', 'myAct', 'myLab');
        at.trigger("6");

        ok(AJS.$.trigger.calledOnce);
        var params = AJS.$.trigger.getCall(0).args[1];

        equal(params.category, "myCat");
        equal(params.action, "myAct");
        equal(params.label, "myLab");
        equal(params.value, 6);

    });

    test('ignores NaN for value with three constructor args', function() {
        var at = new AnalyticsTracker('myCat', 'myAct', 'myLab');
        at.trigger("x");

        ok(AJS.$.trigger.calledOnce);
        var params = AJS.$.trigger.getCall(0).args[1];

        equal(params.category, "myCat");
        equal(params.action, "myAct");
        equal(params.label, "myLab");
        equal(params.value, undefined);

    });

    test('ignores subsequent args to trigger with three constructor args', function() {
        var at = new AnalyticsTracker('myCat', 'myAct', 'myLab');
        at.trigger(5, 6, 7);

        ok(AJS.$.trigger.calledOnce);
        var params = AJS.$.trigger.getCall(0).args[1];

        equal(params.category, "myCat");
        equal(params.action, "myAct");
        equal(params.label, "myLab");
        equal(params.value, 5);

    });

    test('binds to correct event for async', function() {
        var at = new AnalyticsTracker('myCat', 'myAct', 'myLab').setAsync(true);
        at.trigger();

        ok(AJS.$.trigger.calledOnce);
        ok(AJS.$.trigger.calledWith("gh.analytics.async"));

    });

    test("removes spaces from category and action names", function() {
        var at = new AnalyticsTracker('my cat e gory');
        at.trigger('my act ion', 'my lab el', 1);

        ok(AJS.$.trigger.calledOnce);
        var params = AJS.$.trigger.getCall(0).args[1];

        equal(params.category, 'mycategory', "Spaces stripped from category name");
        equal(params.action, 'myaction', "Spaces stripped from action name");
        equal(params.label, 'my lab el', "Spaces aren't stripped from label");
    });
});