AJS.test.require("com.pyxis.greenhopper.jira:gh-rapid", function() {
    var Events = require('jira-agile/rapid/events');

    module("Events tests");

    test("Binding to and triggering events, with new Events()", function() {
        var events = new Events();
        var handler = sinon.spy();
        events.on('change', handler);
        strictEqual(handler.callCount, 0, "Handler not called yet");
        events.trigger('change', 'a', 1);
        strictEqual(handler.callCount, 1, "Handler is called after event is triggered");
        ok(handler.calledWithExactly('a', 1), "Arguments are passed to the handler");
    });

    test("Binding to and triggering events, with Events(obj)", function() {
        var obj = { foo: 'bar' };
        var handler = sinon.spy();
        var newObj = Events(obj);
        ok(newObj === obj, "Return obj");
        strictEqual(obj.foo, 'bar', "Preserved properties on obj");
        obj.on('change', handler);
        strictEqual(handler.callCount, 0, "Handler not called yet");
        obj.trigger('change', 'a', 1);
        strictEqual(handler.callCount, 1, "Handler is called after event is triggered");
        ok(handler.calledWithExactly('a', 1), "Arguments are passed to the handler");
    });

    test("Binding another handler to same event and context unbinds previous one", function() {
        var events = new Events();
        var firstHandler = sinon.spy();
        var secondHandler = sinon.spy();
        var context = {};
        events.on('change', firstHandler, context);
        events.on('change', secondHandler, context);
        events.trigger('change');
        strictEqual(firstHandler.callCount, 0, "First handler is unbound");
        strictEqual(secondHandler.callCount, 1, "Second handler is called");
    });

    test("Binding to same event without context doesn't override each other", function() {
        var events = new Events();
        var firstHandler = sinon.spy();
        var secondHandler = sinon.spy();
        events.on('change', firstHandler);
        events.on('change', secondHandler);
        events.trigger('change');
        strictEqual(firstHandler.callCount, 1, "First handler is called");
        strictEqual(secondHandler.callCount, 1, "Second handler is called");
    });

    test("Binding to same event but different contexts don't override each other", function() {
        var events = new Events();
        var firstHandler = sinon.spy();
        var secondHandler = sinon.spy();
        var context1 = {};
        var context2=  {};
        events.on('change', firstHandler, context1);
        events.on('change', secondHandler, context2);
        events.trigger('change');
        strictEqual(firstHandler.callCount, 1, "First handler is called");
        strictEqual(secondHandler.callCount, 1, "Second handler is called");
    });

    test("Binding to different events but same context don't override each other", function() {
        var events = new Events();
        var changeHandler = sinon.spy();
        var unchangeHandler = sinon.spy();
        var context = {};
        events.on('change', changeHandler, context);
        events.on('unchange', unchangeHandler, context);
        events.trigger('change');
        strictEqual(changeHandler.callCount, 1, "Change handler is called");
        strictEqual(unchangeHandler.callCount, 0, "Unchange handler is not called");
        changeHandler.reset();
        events.trigger('unchange');
        strictEqual(changeHandler.callCount, 0, "Change handler is not called");
        strictEqual(unchangeHandler.callCount, 1, "Unchange handler is called");
    });

    test("Unbinding all by event", function() {
        var events = new Events();
        var handler1 = sinon.spy();
        var handler2 = sinon.spy();
        var otherHandler = sinon.spy();
        var context1 = {};
        var context2 = {};
        events.on('change', handler1, context1);
        events.on('change', handler2, context2);
        events.on('unchange', otherHandler, context1);
        events.off('change');
        events.trigger('change');
        events.trigger('unchange');
        strictEqual(handler1.callCount, 0, "Handler is not called after being unbound");
        strictEqual(handler2.callCount, 0, "Handler is not called after being unbound");
        strictEqual(otherHandler.callCount, 1, "Other handler is not incorrectly unbound");
    });

    test("Unbinding all by context", function() {
        var events = new Events();
        var changeHandler = sinon.spy();
        var unchangeHandler = sinon.spy();
        var otherHandler = sinon.spy();
        var context1 = {};
        var context2 = {};
        events.on('change', changeHandler, context1);
        events.on('unchange', unchangeHandler, context1);
        events.on('change', otherHandler, context2);
        events.off(context1);
        events.trigger('change');
        events.trigger('unchange');
        strictEqual(changeHandler.callCount, 0, "Handler is not called after being unbound");
        strictEqual(unchangeHandler.callCount, 0, "Handler is not called after being unbound");
        strictEqual(otherHandler.callCount, 1, "Other handler is not incorrectly unbound");
    });

    test("Unbinding all by handler", function() {
        var events = new Events();
        var handler = sinon.spy();
        var otherHandler = sinon.spy();
        events.on('change', handler);
        events.on('change', handler);
        events.on('unchange', handler);
        events.on('unchange', handler);
        events.on('change', otherHandler);
        events.off(handler);
        events.trigger('change');
        events.trigger('unchange');
        strictEqual(handler.callCount, 0, "Handler is not called after being unbound");
        strictEqual(otherHandler.callCount, 1, "Other handler is not incorrectly unbound");
    });
});