define("jira-agile/rapid/page-renderer", [], function () {
    "use strict";
    /**
     * This is used as a global entry point for the soy/js rendering chain. Call from the velocity template.
     */

    var PageRenderer = {};

    /**
     * Render the page, based on the model. The two renderers are expected to deal with whatever model data is present.
     *
     * TODO In the future, we're going to use this as a global Javascript Exception handler, similar to the 500 page.
     *
     * @param successRenderer : This will be called if there were no errors during page load
     * @param errorRenderer : This will be called if there were errors.
     */
    PageRenderer.render = function (successRenderer, errorRenderer) {
        if (GH.view.pageLoadErrors != null) {
            errorRenderer();
        } else {
            successRenderer();
        }
    };

    PageRenderer.showException = function (e) {
        // TODO do something fancy here with stacktraces (needs external lib), proper error display and whatnot.
        // TODO figure out how to make stuff show up in firebug as well
        alert(e.message);
    };

    return PageRenderer;
});

AJS.namespace("GH.PageRenderer", null, require("jira-agile/rapid/page-renderer"));