/**
 * Holds current user information.
 * Logged in information is taken from a html meta attribute, rest of data is
 * retrieved/refreshed when the configuration is loaded
 */
define('jira-agile/rapid/user-data', ["jira/util/data/meta"], function (Meta) {

    var UserData = {};

    /**
     * Directly load the user from the dom
     */
    UserData.remoteUser = Meta.get("remote-user");
    UserData.loggedIn = !!UserData.remoteUser;

    /**
     * Is there a logged in user?
     */
    UserData.hasUser = function () {
        return UserData.loggedIn;
    };

    /**
     * Get the current username
     */
    UserData.getUserName = function () {
        return UserData.remoteUser;
    };

    UserData.canCreateProject = function () {
        return UserData.userConfig.canCreateProject;
    };

    /**
     * Sets user data retrieved from the server
     */
    UserData.setGlobalConfig = function (globalConfig) {
        UserData.quickCreateDefaultIssueTypeId = globalConfig.quickCreateDefaultIssueTypeId;
        // just copy properties form config object to user data
        UserData.userConfig = globalConfig.userConfig;

        if (UserData.userConfig && UserData.userConfig.canCreateProject) {
            UserData.userConfig.canCreateProject = !GH.Features.DISABLE_CREATE_PROJECT.isEnabled();
        }
    };

    return UserData;
});

AJS.namespace('GH.UserData', null, require('jira-agile/rapid/user-data'));