AJS.test.require(["com.pyxis.greenhopper.jira:gh-test-common-base", "com.pyxis.greenhopper.jira:gh-rapid-config"], function () {
    var CardColorConfig = require("jira-agile/rapid/configuration/card-color-config");

    module("Ajax tests", {
        setup: function setup() {
            GH.Test.setUpFakeServer(this);
            CardColorConfig.model = {
                rapidViewId: 1
            };
        },
        teardown: function teardown() {
            GH.Test.restoreServer(this);
        }
    });

    /* The purpose of these tests is to ensure the ajax calls are not broken while making a significant refactoring to how GH.Ajax works */
    test("loadStrategyConfig: Successful AJAX call renders the configuration table", sinon.test(function () {

        this.stub(CardColorConfig, "renderConfigurationTable");

        GH.Test.respondToGetWith200(this, "/cardcolors/(.*)/strategy/", {});

        CardColorConfig.loadStrategyConfig({ id: 1 });

        this.server.respond();

        ok(CardColorConfig.renderConfigurationTable.called, "Called success method");
    }));

    test("loadStrategyConfig: Failed AJAX call handles authentication error", sinon.test(function () {
        this.stub(GH.RapidViewConfig, "handleRapidLoadError");

        GH.Test.respondToGetWith500(this, "/cardcolors/(.*)/strategy/", {});

        CardColorConfig.loadStrategyConfig({ id: 1 });

        this.server.respond();

        ok(!GH.RapidViewConfig.handleRapidLoadError.called, "Did not call success method on failure");
    }));

    test("hidePicker: Submits Ajax put request", function () {
        var url = new RegExp("^" + GH.Ajax.buildRestUrl("/cardcolors/") + "(.*)" + "/color/" + "(.*)");

        var fakeRow = {
            model: {
                get: function get() {
                    return 1;
                },
                toJSON: function toJSON() {
                    return {};
                }
            }
        };
        CardColorConfig.hidePicker(null, fakeRow);

        equal(this.server.requests.length, 1);

        var put = this.server.requests[0];
        ok(url.test(put.url));
        equal(put.requestBody, "{}");
    });

    test("saveStrategySelection: Successful AJAX call loads strategy selection and triggers analytics", sinon.test(function () {
        // just spy on analytics to ensure it has got that far
        this.stub(CardColorConfig, "loadStrategyConfig");
        this.stub(CardColorConfig, "getStrategyById").returns(1);

        GH.Test.respondToPutWith200(this, "/cardcolors/(.*)/strategy", {});

        CardColorConfig.saveStrategySelection();

        ok(GH.Test.isRequestDataStringified(this.server.requests[0]));

        this.server.respond();

        ok(CardColorConfig.loadStrategyConfig.called, "Called success method");
    }));

    test("saveStrategySelection: Failed AJAX call does nothing (No specific error handling)", sinon.test(function () {
        this.stub(CardColorConfig, "loadStrategyConfig");
        this.stub(CardColorConfig, "getStrategyById").returns(1);

        GH.Test.respondToPutWith500(this, "/cardcolors/(.*)/strategy", {});

        CardColorConfig.saveStrategySelection();

        ok(GH.Test.isRequestDataStringified(this.server.requests[0]));

        this.server.respond();

        ok(!CardColorConfig.loadStrategyConfig.called, "Did not call success method on failure");
    }));
});