define('jira-agile/rapid/configuration/card-layout-config', [
    'jira-agile/rapid/configuration/card-layout-config-table',
    'jquery'
], function(
    CardLayoutConfigTable,
    $
) {
    'use strict';

    function CardLayoutConfig(model, el) {
        this.model = model.cardLayoutConfig;
        this.isSprintSupportEnabled = model.isSprintSupportEnabled;
        this.isKanPlanEnabled = model.isKanPlanEnabled;
        this.el = $(el);
    }

    CardLayoutConfig.prototype = {
        render: function () {
            this.el.html(GH.tpl.cardlayoutconfig.renderCardLayoutConfig({
                isSprintSupportEnabled: this.isSprintSupportEnabled,
                isKanPlanEnabled: this.isKanPlanEnabled
            }));
            if (this.isSprintSupportEnabled || this.isKanPlanEnabled) {
                new CardLayoutConfigTable('planMode', this.model, '#ghx-card-layout-config-plan').render();
            }
            new CardLayoutConfigTable('workMode', this.model, '#ghx-card-layout-config-work').render();
        }
    };

    return CardLayoutConfig;
});

AJS.namespace('GH.CardLayoutConfig', null, require('jira-agile/rapid/configuration/card-layout-config'));
