define('jira-agile/rapid/configuration/column-config-analytics', ['underscore', 'jira-agile-column-configuration-status-dnd-state', 'jira/analytics'], function (_, statusDndState, analyticsTrigger) {
    var analytics = {};

    analytics.triggerStatusDnDAnalytics = function (model, $sourceColumn, $destinationColumn) {
        var params = statusDndState.getBoardStateAfterStatusDnd(model, $sourceColumn, $destinationColumn);

        analyticsTrigger.send({
            name: 'jira-software.config.columns.status.dnd',
            properties: params
        });
    };

    /**
     * Trigger analytics event when column config page is visible
     * @param model
     * @param canEdit
     */
    analytics.triggerTabOpenedAnalytics = function (model, canEdit) {
        var params = statusDndState.basicEventData(model);

        params.canEdit = canEdit;
        params.kanplanEnabled = !!GH.RapidBoard.Config.Columns.kanPlanConfig.isKanPlanEnabled;

        analyticsTrigger.send({
            name: 'jira-software.config.columns.opened',
            properties: params
        });
    };

    analytics.triggerKanbanBacklogEnabledGoToBacklogLink = function (model, $sourceColumn, $destinationColumn) {
        var params = statusDndState.getBoardStateAfterStatusDnd(model, $sourceColumn, $destinationColumn);

        analyticsTrigger.send({
            name: 'jira-software.config.kanplan.enable.goto.backlog',
            properties: params
        });
    };

    analytics.triggerKanbanDisabledFeedbackCollectorLink = function (model, $sourceColumn, $destinationColumn) {
        var params = statusDndState.getBoardStateAfterStatusDnd(model, $sourceColumn, $destinationColumn);

        analyticsTrigger.send({
            name: 'jira-software.config.kanplan.disable.feedback',
            properties: params
        });
    };

    return analytics;
});