AJS.test.require(["com.pyxis.greenhopper.jira:gh-test-common", "com.pyxis.greenhopper.jira:gh-rapid-config"], function () {
    var $ = require("jquery");
    var DetailViewConfig = require("jira-agile/rapid/configuration/detail-view-config");

    module("Detail Config View", {
        setup: function setup() {
            GH.Test.setUpFakeServer(this);
            AJS.$('#qunit-fixture').append('<div id="ghx-config-detailView"></div>');
            $('#ghx-config-detailView').html(GH.tpl.detailviewconfig.renderDetailViewConfig({}));
        },
        teardown: function teardown() {
            DetailViewConfig.model = {};
            GH.Test.restoreServer(this);
        },
        peopleTestData: {
            canEdit: true,
            availableFields: [{
                category: "people",
                fieldId: "architect",
                id: 22,
                isEstimationField: false,
                isValid: true,
                name: "Architect"
            }, {
                category: "people",
                fieldId: "custom_field_1003",
                id: 22,
                isEstimationField: false,
                isValid: true,
                name: "Domain Specialist"
            }],
            currentFields: [{ category: "people" }]
        },
        unsupportedFieldTestData: {
            canEdit: true,
            availableFields: [{}],
            currentFields: [{
                category: "unsupported",
                fieldId: "unsupported",
                id: 23,
                isEstimationField: false,
                isValid: true,
                name: "Unsupported test name"
            }]
        }
    });

    test("DetailViewConfig.renderConfig: it should load two RESTful tables: one for fields in details category, one for fields in date category", function () {

        sinon.stub(DetailViewConfig, "renderConfigurationTable");

        var fakeModel = { canEdit: true };
        DetailViewConfig.model = fakeModel;
        DetailViewConfig.renderConfig();

        ok(DetailViewConfig.renderConfigurationTable.callCount == 5);
        ok(DetailViewConfig.renderConfigurationTable.calledWith("unsupported"));
        ok(DetailViewConfig.renderConfigurationTable.calledWith("details"));
        ok(DetailViewConfig.renderConfigurationTable.calledWith("dates"));
        ok(DetailViewConfig.renderConfigurationTable.calledWith("people"));
        ok(DetailViewConfig.renderConfigurationTable.calledWith("links"));

        DetailViewConfig.renderConfigurationTable.restore();
    });

    test("GH.DetailViewConfig.renderConfigurationTable: it creates a table inside the correct form", function () {
        var fakeModel = { canEdit: true, availableFields: [], currentFields: [{ category: "details" }] };
        DetailViewConfig.model = fakeModel;

        DetailViewConfig.renderConfigurationTable("details");

        var isRenderedInCorrectElement = $("#ghx-detail-view-field-table-form-details").html() && !$("#ghx-detail-view-field-table-form-dates").html();
        ok(isRenderedInCorrectElement, 'table is created in the correct form');
    });

    test("GH.DetailViewConfig.addPeople: people are added correctly to the people table", function () {
        GH.Test.respondToGetWith200(this, 'detailviewfield/(.*)/available', {});
        GH.Test.respondWith(this, 'detailviewfield/(.*)/field', {
            category: "people",
            fieldId: "architect",
            id: 22,
            isEstimationField: false,
            isValid: true,
            name: "Architect"
        }, 'POST', 200);
        var fakeModel = this.peopleTestData;
        DetailViewConfig.model = fakeModel;

        //render the people config table
        DetailViewConfig.renderConfigurationTable("people");
        var $detailViewConfigPeopleForm = $('#ghx-detail-view-field-table-form-people form');
        ok($detailViewConfigPeopleForm.length > 0, 'People config table was rendered');

        //click on the add button to add a person to the table
        $detailViewConfigPeopleForm.find('input[value="aui.words.add"]').click();
        this.server.respond();

        ok($detailViewConfigPeopleForm.find('tr[data-fieldid="architect"]').length > 0, 'correct field was added to the table');
    });

    test("Unsupported fields table is deleted when the last unsupported field is deleted", function () {
        DetailViewConfig.model = this.unsupportedFieldTestData;

        // render the Unsupported fields config table
        DetailViewConfig.renderConfigurationTable('unsupported');
        var $detailViewConfigUnsupportedFieldsForm = $('#ghx-detail-view-field-table-form-unsupported form');
        ok($detailViewConfigUnsupportedFieldsForm.length > 0, 'Unsupported fields config table was rendered');

        // check that the table has our field in it
        ok($detailViewConfigUnsupportedFieldsForm.find('tr[data-fieldid="unsupported"]').length === 1, 'Unsupported field is already in table');

        // click on the delete button to get rid of the unsupported field
        $detailViewConfigUnsupportedFieldsForm.find('td.aui-restfultable-operations a:contains("gh.restfultable.words.delete")').click();
        this.server.respond();

        // check that the table has been hidden
        ok($detailViewConfigUnsupportedFieldsForm.find('tr[data-fieldid="unsupported"]').length > 0, 'Unsupported fields table is hidden');
    });

    module("getAvailableDetailViewFields", {
        setup: function setup() {
            GH.Test.setUpFakeServer(this);
            DetailViewConfig.model = {};
        },
        teardown: function teardown() {
            GH.Test.restoreServer(this);
        }
    });

    /* The purpose of these tests is to ensure the ajax calls are not broken while making a significant refactoring to how GH.Ajax works */
    test("Successful AJAX call sets available fields in model", function () {

        GH.Test.respondToGetWith200(this, "/detailviewfield/" + "(.*)" + "/available", { fields: "fields" });

        DetailViewConfig.getAvailableDetailViewFields(true);

        this.server.respond();

        equal(DetailViewConfig.model.availableFields, "fields", "Called success method");
    });

    test("Failed AJAX call does nothing", function () {

        GH.Test.respondToGetWith500(this, "/detailviewfield/" + "(.*)" + "/available", {});

        DetailViewConfig.getAvailableDetailViewFields(true);

        this.server.respond();

        equal(DetailViewConfig.model.availableFields, undefined, "Did not set fields due to failure");
    });
});