define('jira-agile/rapid/configuration/kanban-backlog-flags', [
    'jira-agile/rapid/configuration/timed-flag',
    'jira-agile/rapid/configuration/kanban-backlog-feedback-collector',
    'jira-agile/rapid/configuration/column-config-analytics',
    'jira/util/formatter',
    'jira-agile/rapid/ui/kanplan/kan-plan-feature-service'
], function (flag,
             collector,
             ColumnConfigAnalytics,
             formatter,
             KanplanFeatureService) {
    var AUTO_CLOSE_TIME = 10000;

    return {
        kanplanDisabledFlag: function (model, $sourceColumn, $destinationColumn) {
            var $flagDisabledContent = flag.successMsgTimed(
                formatter.I18n.getText('gh.rapid.config.kanplan.columns.feature.disabled.title'),
                GH.tpl.columnconfig.kanplanDisabledFlag({
                    epicPanelEnabled: model.showEpicAsPanel && KanplanFeatureService.isEpicsAndVersionsEnabled()
                }),
                {},
                AUTO_CLOSE_TIME
            );
            var $feedbackLink = $flagDisabledContent.find('a.kanplan-feedback');
            collector.configureFeedbackCollector($feedbackLink, model, $sourceColumn, $destinationColumn);
        },

        kanplanEnabledFlag: function (model, $sourceColumn, $destinationColumn) {
            var $flagEnabledContent = flag.successMsgTimed(
                formatter.I18n.getText('gh.rapid.config.kanplan.columns.feature.enabled.title'),
                GH.tpl.columnconfig.kanplanEnabledFlag({id: GH.RapidBoard.Config.editedRapidViewId, view: "planning"}),
                {},
                AUTO_CLOSE_TIME
            );
            $flagEnabledContent.find('a.kanplan-board').click(function () {
                ColumnConfigAnalytics.triggerKanbanBacklogEnabledGoToBacklogLink(model, $sourceColumn, $destinationColumn);
            });
        }
    };
});