AJS.test.require(["com.pyxis.greenhopper.jira:gh-test-common", "com.pyxis.greenhopper.jira:gh-rapid-config"], function () {
    module("loadEditModel", {
        setup: function setup() {
            GH.Test.setUpFakeServer(this);
        },
        teardown: function teardown() {
            GH.Test.restoreServer(this);
        }
    });

    // The purpose of these tests is to ensure the ajax calls are not broken while making a significant refactoring to how GH.Ajax works
    test("loadEditModel: Successful AJAX calls render the edit screen", sinon.test(function () {

        this.stub(GH.RapidBoard.Config, "renderEditScreen");
        this.stub(GH.State, "toViewState").returns({ rapidView: 1 });

        GH.Test.respondToGetWith200(this, '/xboard/configuration-tabs', {});
        GH.Test.respondToGetWith200(this, '/rapidviewconfig/editmodel.json', {});

        GH.RapidBoard.Config.loadEditModel();

        this.server.respond();

        ok(GH.RapidBoard.Config.renderEditScreen.called, "Called success method");
    }));

    test("loadEditModel: Failed AJAX call does not render (no error handling)", sinon.test(function () {
        this.stub(GH.RapidBoard.Config, "renderEditScreen");
        this.stub(GH.State, "toViewState").returns({ rapidView: 1 });
        this.stub(GH.RapidBoard, "gotoManageViewsPage");

        GH.Test.respondToGetWith200(this, '/xboard/configuration-tabs', {});
        GH.Test.respondToGetWith500(this, '/rapidviewconfig/editmodel.json', {});

        GH.RapidBoard.Config.loadEditModel();

        this.server.respond();

        ok(!GH.RapidBoard.Config.renderEditScreen.called, "Does not render on failure");
    }));

    test("saveViewName: AJAX call is correctly stringified and URL is right", sinon.test(function () {

        this.stub(GH.RapidBoard.Util.InlineEditable, "updateView");

        GH.Test.respondToPutWith200(this, "/rapidviewconfig/name", {});

        GH.RapidBoard.Config.saveViewName({ newValue: "" });

        ok(GH.Test.isRequestDataStringified(this.server.requests[0]));

        this.server.respond();
    }));

    test("endBoardAdminsForm: form not out of focus (i.e. 'x' clicked), should return immediately", sinon.test(function () {

        // need to set up a "mock" BoardAdmin picker field..
        GH.RapidBoard.Config.BoardAdmins = {
            form: {
                getAjaxValue: sinon.stub()
            },
            canUsePicker: true
        };

        // stub the functions we look at
        this.stub(GH.RapidBoard.Config, "shouldHideBoardAdminsForm").returns(false);

        GH.RapidBoard.Config.endBoardAdminsForm();

        // make sure getAjaxValue was never called, as the function should have returned immediately
        ok(!GH.RapidBoard.Config.BoardAdmins.form.getAjaxValue.called, "No ajax data should have been fetched from the picker");
    }));

    test("saveBoardAdmins: Successful AJAX call should reload the edit model and render the view", sinon.test(function () {
        // need to set up a "mock" BoardAdmin picker field..
        GH.RapidBoard.Config.BoardAdmins = {
            form: {
                getAjaxValue: sinon.stub().returns({
                    groupKeys: [],
                    userKeys: []
                })
            },
            canUsePicker: true,
            analytics: {
                update: {
                    trigger: sinon.stub()
                }
            }
        };
        this.stub(GH.RapidBoard.Config, "renderViewBoardAdminsForm");
        this.stub(GH.RapidBoard.Config, "loadEditModel");

        GH.Test.respondToPutWith200(this, "/rapidviewconfig/boardadmins", {});

        GH.RapidBoard.Config.saveBoardAdmins();

        this.server.respond();

        ok(GH.RapidBoard.Config.renderViewBoardAdminsForm.called, "Board admins form should have been re-rendered");
        ok(GH.RapidBoard.Config.loadEditModel.called, "loadEditModel should have been called");
    }));

    module("GH.RapidBoard.Config.Columns.BACKLOG_COLUMN_STATUS_UPDATE event", {
        setup: function setup() {
            this.sandbox = sinon.sandbox.create();

            GH.RapidBoard.Config.Columns.model = { mappedColumns: [{ isKanPlanColumn: true, mappedStatuses: [1, 2, 3] }] };
            GH.RapidBoard.Config.Columns.kanPlanConfig = { isKanPlanEnabled: true };
            GH.RapidBoard.Config.initListeners();

            this.sandbox.spy(GH.tpl.columnconfig, "kanplanEnabledFlag");
            this.sandbox.spy(GH.tpl.columnconfig, "kanplanDisabledFlag");

            this.flag = require('jira/flag');
            this.sandbox.spy(this.flag, "showSuccessMsg");
        },
        teardown: function teardown() {
            this.sandbox.restore();
        }
    });

    test("GH.RapidBoard.Config.Columns.BACKLOG_COLUMN_STATUS_UPDATE event should not show any flag if no change in kanban backlog state", sinon.test(function () {
        var statusDndState = require('jira-agile-column-configuration-status-dnd-state');
        this.stub(statusDndState, "getBoardStateAfterStatusDnd").returns({
            kanplanDisabledAfterOperation: false,
            kanplanEnabledAfterOperation: false
        });

        GH.RapidBoard.Config.Columns.trigger(GH.RapidBoard.Config.Columns.BACKLOG_COLUMN_STATUS_UPDATE, "", "");

        sinon.assert.notCalled(this.flag.showSuccessMsg);
        sinon.assert.notCalled(GH.tpl.columnconfig.kanplanEnabledFlag);
        sinon.assert.notCalled(GH.tpl.columnconfig.kanplanDisabledFlag);
    }));

    test("GH.RapidBoard.Config.Columns.BACKLOG_COLUMN_STATUS_UPDATE event should show flag when kanplan feature is disabled", sinon.test(function () {
        var statusDndState = require('jira-agile-column-configuration-status-dnd-state');
        this.stub(statusDndState, "getBoardStateAfterStatusDnd").returns({
            kanplanDisabledAfterOperation: true,
            kanplanEnabledAfterOperation: false
        });
        GH.RapidBoard.Config.Columns.trigger(GH.RapidBoard.Config.Columns.BACKLOG_COLUMN_STATUS_UPDATE, "", "");
        sinon.assert.calledOnce(this.flag.showSuccessMsg);
        sinon.assert.calledWithMatch(this.flag.showSuccessMsg, "gh.rapid.config.kanplan.columns.feature.disabled.title", "gh.rapid.config.kanplan.columns.feature.disabled.content");
        sinon.assert.notCalled(GH.tpl.columnconfig.kanplanEnabledFlag);
        sinon.assert.calledOnce(GH.tpl.columnconfig.kanplanDisabledFlag);
    }));

    test("GH.RapidBoard.Config.Columns.BACKLOG_COLUMN_STATUS_UPDATE event should show flag when kanplan feature is enabled", sinon.test(function () {
        var statusDndState = require('jira-agile-column-configuration-status-dnd-state');
        this.stub(statusDndState, "getBoardStateAfterStatusDnd").returns({
            kanplanDisabledAfterOperation: false,
            kanplanEnabledAfterOperation: true
        });
        GH.RapidBoard.Config.Columns.trigger(GH.RapidBoard.Config.Columns.BACKLOG_COLUMN_STATUS_UPDATE, "", "");

        sinon.assert.calledOnce(this.flag.showSuccessMsg);
        sinon.assert.calledWithMatch(this.flag.showSuccessMsg, "gh.rapid.config.kanplan.columns.feature.enabled.title", "gh.rapid.config.kanplan.columns.feature.enabled.content");
        sinon.assert.calledOnce(GH.tpl.columnconfig.kanplanEnabledFlag);
        sinon.assert.notCalled(GH.tpl.columnconfig.kanplanDisabledFlag);
    }));
});