
/* globals GH, _ */

AJS.test.require(["com.pyxis.greenhopper.jira:gh-test-common", "com.pyxis.greenhopper.jira:gh-rapid", "com.pyxis.greenhopper.jira:gh-rapid-common"], function () {
    function returnValue(value) {
        return function () {
            return value;
        };
    }

    function MockIssueSelectorModel(issues) {
        this._issues = issues;
    }

    MockIssueSelectorModel.prototype.isIssueValid = function (issueKey) {
        return this.getIssueIndex(issueKey) !== -1;
    };
    MockIssueSelectorModel.prototype.getIssueIndex = function (issueKey) {
        return _.indexOf(this._issues, issueKey);
    };
    MockIssueSelectorModel.prototype.canAddToSelection = function (selectedIssueKeys, issueKey) {
        return this.isIssueValid(issueKey) && !_.contains(selectedIssueKeys, issueKey);
    };
    MockIssueSelectorModel.prototype.getIssueRange = function (fromKey, toKey) {
        var fromIndex = this.getIssueIndex(fromKey);
        var toIndex = this.getIssueIndex(toKey);
        return fromIndex !== -1 && toIndex !== -1 ? this._issues.slice(fromIndex, toIndex + 1) : [];
    };

    function MockStorage() {
        this._local = {};
        this._session = {};
    }

    MockStorage.prototype.get = function (key, useSessionStorage) {
        return this[useSessionStorage ? '_session' : '_local'][key];
    };

    MockStorage.prototype.put = function (key, value, useSessionStorage) {
        this[useSessionStorage ? '_session' : '_local'][key] = value;
        return true;
    };

    module('IssueSelectionManager', {
        setup: function setup() {
            this.oldStorage = GH.storage;
            GH.storage = new MockStorage();
            this.oldGetRapidViewId = GH.RapidBoard.State.getRapidViewId;
            this.oldData = GH.RapidBoard.State.data;
            GH.RapidBoard.State.data = {};
            GH.RapidBoard.State.getRapidViewId = returnValue(1);
            this.manager = new GH.IssueSelectionManager(new MockIssueSelectorModel(['TEST-2', 'TEST-1', 'TEST-3', 'TEST-5', 'TEST-4', 'TEST-6', 'TEST-7', 'TEST-8']), 'blah');
        },
        destroy: function destroy() {
            this.manager = null;
            GH.storage = this.oldStorage;
            GH.RapidBoard.State = this.oldGetRapidViewId;
            GH.RapidBoard.State.data = this.oldData;
        }
    });

    test('selectIssue', function () {
        var manager = this.manager;
        deepEqual(manager.getSelectedIssueKeys(), [], 'there should be no selected issues initially');
        manager.selectIssue('TEST-1');
        deepEqual(manager.getSelectedIssueKeys(), ['TEST-1'], 'TEST-1 should be selected');
        manager.selectIssue('TEST-2');
        deepEqual(manager.getSelectedIssueKeys(), ['TEST-2'], 'TEST-2 should be selected and not TEST-1');
        manager.selectIssue(null);
        deepEqual(manager.getSelectedIssueKeys(), [], 'null should result in no selections instead of ');
    });

    test('validateCurrentSelection', function () {
        var manager = this.manager;
        deepEqual(manager.getSelectedIssueKeys(), [], 'there should be no selected issues initially');
        manager._replaceSelectedIssueKeys(['TEST-1', 'TEST-2']);
        deepEqual(manager.getSelectedIssueKeys(), ['TEST-1', 'TEST-2'], 'TEST-1 and TEST-2 should be selected');
        ok(!manager.validateCurrentSelection(), 'validateCurrentSelection should not signal a change');
        deepEqual(manager.getSelectedIssueKeys(), ['TEST-1', 'TEST-2'], 'TEST-1 and TEST-2 should be selected');
        manager._replaceSelectedIssueKeys(['TEST-3', 'TEST-10', 'TEST-5']);
        deepEqual(manager.getSelectedIssueKeys(), ['TEST-3', 'TEST-10', 'TEST-5'], 'TEST-3, TEST-10 and TEST-5 should be selected');
        ok(manager.validateCurrentSelection(), 'validateCurrentSelection should signal a change');
        deepEqual(manager.getSelectedIssueKeys(), ['TEST-3', 'TEST-5'], 'TEST-3 and TEST-5 should be selected');
    });

    test('handleIssueClick', function () {

        var metaPressed = function metaPressed(options) {
            return options.metaPressed;
        };
        sinon.stub(GH.MouseUtils, "isMetaPressed", metaPressed);

        var shiftPressed = function shiftPressed(options) {
            return options.shiftPressed;
        };
        sinon.stub(GH.MouseUtils, "isShiftPressed", shiftPressed);

        var manager = this.manager;

        // shift select
        deepEqual(manager.getSelectedIssueKeys(), [], 'there should be no selected issues initially');
        ok(manager.handleIssueClick({}, 'TEST-2'), 'handleIssueClick should signal a selection change');
        deepEqual(manager.getSelectedIssueKeys(), ['TEST-2'], 'TEST-2 should be selected');
        ok(manager.handleIssueClick({ shiftPressed: true }, 'TEST-3'), 'handleIssueClick shuold signal a selection change');
        deepEqual(manager.getSelectedIssueKeys(), ['TEST-2', 'TEST-1', 'TEST-3'], 'TEST-2 TEST-1 and TEST-3 should be selected');

        // meta select
        ok(manager.handleIssueClick({}, 'TEST-1'), 'handleIssueClick should signal a selection change');
        deepEqual(manager.getSelectedIssueKeys(), ['TEST-1'], 'TEST-1 should be selected');
        ok(manager.handleIssueClick({ metaPressed: true }, 'TEST-5'), 'handleIssueClick shuold signal a selection change');
        deepEqual(manager.getSelectedIssueKeys(), ['TEST-1', 'TEST-5'], 'TEST-5 should be selected');
        ok(manager.handleIssueClick({ metaPressed: true }, 'TEST-2'), 'handleIssueClick shuold signal a selection change');
        deepEqual(manager.getSelectedIssueKeys(), ['TEST-1', 'TEST-5', 'TEST-2'], 'TEST-1, TEST-5 and TEST-2 should be selected');

        // meta+shift select
        ok(manager.handleIssueClick({}, 'TEST-2'), 'handleIssueClick should signal a selection change');
        deepEqual(manager.getSelectedIssueKeys(), ['TEST-2'], 'TEST-2 should be selected');
        ok(manager.handleIssueClick({ shiftPressed: true }, 'TEST-3'), 'handleIssueClick should signal a selection change');
        deepEqual(manager.getSelectedIssueKeys(), ['TEST-2', 'TEST-1', 'TEST-3'], 'TEST-2, TEST-1 and TEST-3 should be selected');
        ok(manager.handleIssueClick({ metaPressed: true }, 'TEST-4'), 'handleIssueClick shuold signal a selection change');
        deepEqual(manager.getSelectedIssueKeys(), ['TEST-2', 'TEST-1', 'TEST-3', 'TEST-4'], 'TEST-2, TEST-1, TEST-3 and TEST-4 should be selected');
        ok(manager.handleIssueClick({ metaPressed: true, shiftPressed: true }, 'TEST-7'), 'handleIssueClick shuold signal a selection change');
        deepEqual(manager.getSelectedIssueKeys(), ['TEST-2', 'TEST-1', 'TEST-3', 'TEST-4', 'TEST-6', 'TEST-7'], 'TEST-2, TEST-1, TEST-3, TEST-4, TEST-6, TEST-7 should be selected');

        // rubbish select
        ok(manager.handleIssueClick({}, 'TEST-2'), 'handleIssueClick should signal a selection change');
        deepEqual(manager.getSelectedIssueKeys(), ['TEST-2'], 'TEST-2 should be selected');
        ok(!manager.handleIssueClick({}, 'TEST-1000'), 'handleIssueClick should not signal a selection change');
        deepEqual(manager.getSelectedIssueKeys(), ['TEST-2'], 'TEST-2 should be selected');
    });
});