GH.ScrollUtils = {};

/**
 * Scrolls the container to reveal the element in the viewport.
 *
 * @param {AJS.$} $scrollingContainer a scrolling container
 * @param {{top: number, bottom: number}} elementRect the rectangle of the element to reveal
 * @param {{top: number, bottom: number}} viewportRect the rectangle of the viewport
 */
GH.ScrollUtils.scrollElementToViewPort = function ($scrollingContainer, viewportRect, elementRect) {
    var containerScrollTop = $scrollingContainer.scrollTop();
    var scrollOffset = 0;
    if (elementRect.top < viewportRect.top) {
        // the element is before the view port begining
        scrollOffset = elementRect.top - viewportRect.top;
    } else if (viewportRect.bottom < elementRect.bottom) {
        // the element is after the view port ending
        scrollOffset = elementRect.bottom - viewportRect.bottom;
    }

    if (scrollOffset !== 0) {
        $scrollingContainer.animate({
            scrollTop: containerScrollTop + scrollOffset
        }, 'fast');
    }
};