GH.RapidBoard.BoardHeader = {};

GH.RapidBoard.BoardHeader.init = function() {
    GH.RapidBoard.BoardHeader._originalPageTitle = document.title;
};

/**
 * Updates the header and the page title
 */
GH.RapidBoard.BoardHeader.update = function(rapidViewData) {
    GH.RapidBoard.BoardHeader.updateHeader(rapidViewData);
    GH.RapidBoard.BoardHeader.updatePageTitle(rapidViewData);
};

GH.RapidBoard.BoardHeader.updateHeader = function(rapidViewData) {
    if (!rapidViewData.id && !rapidViewData.invalidView) {
        // show the simple header
        AJS.$('#ghx-view-selector').html(GH.tpl.boardheader.renderSimpleHeader({
            name : AJS.I18n.getText('gh.rapid.no.views')
        }));
    } else {

        // render the header html
        var hasSelectedView = !!rapidViewData.id;
        var selectedViewName = hasSelectedView ? rapidViewData.name : AJS.I18n.getText('gh.rapid.board.error.noview');
        var selectedViewId = hasSelectedView ? rapidViewData.id : false;

        // render the header
        AJS.$('#ghx-view-selector').html(GH.tpl.boardheader.renderBoardHeader({
            name: selectedViewName,
            viewId: selectedViewId
        }));
    }
};

/**
 * Updates the page title with the selected rapid view name
 */
GH.RapidBoard.BoardHeader.updatePageTitle = function(selectedView) {
    if (selectedView && selectedView.name) {
        document.title = selectedView.name + ' - ' + GH.RapidBoard.BoardHeader._originalPageTitle;
    } else {
        document.title = GH.RapidBoard.BoardHeader._originalPageTitle;
    }
};
