AJS.test.require(['com.pyxis.greenhopper.jira:gh-test-common', 'com.pyxis.greenhopper.jira:gh-rapid'], function() {
    var BurndownChartModel = require('jira-agile/rapid/ui/chart/burndown-chart-model');
    var BurndownRate = require('jira-agile/rapid/ui/chart/burndown-rate');
    var GlobalEvents = require('jira-agile/rapid/global-events');
    GlobalEvents.trigger('pre-initialization');

    var startDate = new Date(2012, 10, 26).valueOf(); // Monday
    var endDate = new Date(2012, 11, 7).valueOf(); // Friday, 11 days later
    var startWeekend = new Date(2012, 11, 1).valueOf();
    var endWeekend = new Date(2012, 11, 3).valueOf();

    module('Guideline calculation');

    test('module "jira-agile/rapid/ui/chart/burndown-chart-model" exists', function() {
        ok(BurndownChartModel);
        ok(GH.BurndownChartModel);
    });

    test('Calculates a straight guideline if there are no non-working days', function() {
        var workRateData = {
            timezone: 'Australia/Sydney',
            rates: [
                { start: startDate, end: endDate, rate: 1 }
            ]
        };

        BurndownRate.setRateData(workRateData);
        var guidelineSeries = BurndownChartModel.calculateGuidelineSeries({startTime: startDate, endTime: endDate, startValue: 10});

        // Should have 2 points: start, end
        equal(guidelineSeries.data.length, 2);

        // check start and end values
        equal(guidelineSeries.data[0][0], startDate);
        equal(guidelineSeries.data[0][1], 10);
        equal(guidelineSeries.data[1][0], endDate);
        equal(guidelineSeries.data[1][1], 0);
    });

    test('Calculates a guideline allowing for non-working days', function() {
        var workRateData = {
            timezone: 'Australia/Sydney',
            rates: [
                { start: startDate, end: startWeekend, rate: 1 },
                { start: startWeekend, end: endWeekend, rate: 0 },
                { start: endWeekend, end: endDate, rate: 1 }
            ]
        };

        BurndownRate.setRateData(workRateData);
        var guidelineSeries = BurndownChartModel.calculateGuidelineSeries({startTime: startDate, endTime: endDate, startValue: 9});

        // Should have only 4 points: start, start weekend, end weekend, end
        equal(guidelineSeries.data.length, 4);

        // check start and end values
        // 9 working days, 9 points = 1 point per day
        equal(guidelineSeries.data[0][0], startDate);
        equal(guidelineSeries.data[0][1], 9);

        equal(guidelineSeries.data[1][0], startWeekend);
        equal(guidelineSeries.data[1][1], 4);

        equal(guidelineSeries.data[2][0], endWeekend);
        equal(guidelineSeries.data[2][1], 4);

        equal(guidelineSeries.data[3][0], endDate);
        equal(guidelineSeries.data[3][1], 0);
    });

    test('Calculates the guideline correctly if the last day is a non-working day', function() {
        var workRateData = {
            timezone: 'Australia/Sydney',
            rates: [
                { start: startDate, end: startWeekend, rate: 1 },
                { start: startWeekend, end: endWeekend, rate: 0 }
            ]
        };

        BurndownRate.setRateData(workRateData);
        var guidelineSeries = BurndownChartModel.calculateGuidelineSeries({startTime: startDate, endTime: endWeekend, startValue: 9});

        // Should have 3 points: start, end of working time, end of chart
        equal(guidelineSeries.data.length, 3);

        // check start and end values
        // 9 working days, 9 points = 1 point per day
        equal(guidelineSeries.data[0][0], startDate);
        equal(guidelineSeries.data[0][1], 9);

        equal(guidelineSeries.data[1][0], startWeekend);
        equal(guidelineSeries.data[1][1], 0);

        equal(guidelineSeries.data[2][0], endWeekend);
        equal(guidelineSeries.data[2][1], 0);
    });

    test('Calculates a guideline where rate definitions go past the end time', function() {
        var workRateData = {
            timezone: 'Australia/Sydney',
            rates: [
                { start: startDate, end: startWeekend, rate: 1 },
                { start: startWeekend, end: endWeekend, rate: 0 },
                { start: endWeekend, end: endDate + 100000, rate: 1 },
                { start: endDate + 100000, end: endDate + 200000, rate: 0 },
                { start: endDate + 200000, end: endDate + 300000, rate: 1 }
            ]
        };

        BurndownRate.setRateData(workRateData);
        var guidelineSeries = BurndownChartModel.calculateGuidelineSeries({startTime: startDate, endTime: endDate, startValue: 9});

        // Should have only 4 points: start, start weekend, end weekend, end
        equal(guidelineSeries.data.length, 4);

        // check start and end values
        // 9 working days, 9 points = 1 point per day
        equal(guidelineSeries.data[0][0], startDate);
        equal(guidelineSeries.data[0][1], 9);

        equal(guidelineSeries.data[1][0], startWeekend);
        equal(guidelineSeries.data[1][1], 4);

        equal(guidelineSeries.data[2][0], endWeekend);
        equal(guidelineSeries.data[2][1], 4);

        equal(guidelineSeries.data[3][0], endDate);
        equal(guidelineSeries.data[3][1], 0);
    });

    module('Non-working days');

    test('Knows when there are any working days', function() {
        var workRateData = {
            timezone: 'Australia/Sydney',
            rates: [
                { start: startDate, end: startWeekend, rate: 1 },
                { start: startWeekend, end: endWeekend, rate: 0 },
                { start: endWeekend, end: endDate, rate: 1 }
            ]
        };

        BurndownRate.setRateData(workRateData);
        ok(BurndownChartModel.hasAnyWorkingDays());

        var noWorkRates = {
            timezone: 'Australia/Sydney',
            rates: [
                { start: startDate, end: startWeekend, rate: 0 },
                { start: startWeekend, end: endWeekend, rate: 0 },
                { start: endWeekend, end: endDate, rate: 0 }
            ]
        };

        BurndownRate.setRateData(noWorkRates);
        ok(!BurndownChartModel.hasAnyWorkingDays());
    });
});
