/* global GH */
/**
 * Chart Controller
 * @module jira-agile/rapid/ui/chart/chart-controller
 * @requires module:underscore
 * @requires module:jira-agile/rapid/ui/chart/burndown-rate
 * @requires module:jira-agile/rapid/ui/chart/chart-colors
 */
define('jira-agile/rapid/ui/chart/chart-controller', ['require'], function (require) {
    'use strict';

    // REQUIRES
    var _ = require('underscore');
    var BurndownRate = require('jira-agile/rapid/ui/chart/burndown-rate');
    var ChartColors = require('jira-agile/rapid/ui/chart/chart-colors');

    // GLOBALS... FIX ME
    var RapidViewConfig = GH.RapidViewConfig;

    /*
     * Grouping together functions for charts that share the same functionality
     */
    var ChartController = {};

    /* Load Configuration data then pass to next data load method */
    ChartController.loadRapidViewConfig = function (chartController, callback) {
        var fn = function (data) {
            // ignore if we are not displayed anymore
            if (!chartController.displayed) {
                return;
            }
            chartController.rapidViewConfig = data;

            callback(data);
        };

        RapidViewConfig.fetchConfiguration(chartController.rapidViewData.id).done(fn);
    };

    ChartController.getNonWorkingBlocks = function () {
        var nonWorkingBlocks = BurndownRate.getNonWorkingDays();

        var markings = _.map(nonWorkingBlocks, function (block) {
            return {
                xaxis: {
                    from: block.start,
                    to: block.end
                },
                color: ChartColors.nonWorkingDays
            };
        });

        return markings;
    };

    return ChartController;
});
