// Tooltip object to display on a chart

GH.ChartTooltip = function (item, tooltipData, type) {
    this.item = item;
    this.data = tooltipData;
    this.type = type;
};

GH.ChartTooltip.prototype.render = function () {
    var ChangeEvent = require('jira-agile/rapid/ui/chart/change-event');
    var tooltip;
    if (this.type === ChangeEvent.releaseDate) {
        tooltip = AJS.$(GH.tpl.charttooltip.renderReleaseDatePredictionTooltip({
            data: this.data
        }));
    } else if (this.type === ChangeEvent.startDate) {
        tooltip = AJS.$(GH.tpl.charttooltip.renderStartDateTooltip({
            data: this.data
        }));
    } else if (this.type === ChangeEvent.uncertainty) {
        tooltip = AJS.$(GH.tpl.charttooltip.renderUncertainty({
            tooltipData: this.data
        }));
    } else {
        tooltip = AJS.$(GH.tpl.charttooltip.renderTooltip({
            tooltipData: this.data
        }));
    }

    var x = this.item.pageX;
    var y = this.item.pageY;
    var series = this.item.series;

    tooltip.css({
        position: 'absolute',
        display: 'none',
        top: y + 5,
        'border-left-color': series.color
    });

    // append to the body (which will give us the correct width)
    tooltip.appendTo("body");

    // check whether we overshoot the right border, in which case we want to display the tooltip to the left
    var tooltipWidth = tooltip.width();
    var canvas = AJS.$('#ghx-chart-view canvas.base');

    // now set the correct x position for the tooltip
    if (x + tooltipWidth > canvas.offset().left + canvas.width()) {
        tooltip.css({ left: x - (30 + tooltipWidth) });
    } else {
        tooltip.css({ left: x + 15 });
    }
    tooltip.fadeIn(200);
};