AJS.test.require(["com.pyxis.greenhopper.jira:gh-rapid", "com.pyxis.greenhopper.jira:gh-test-common"], function () {
    test("JQL links correctly generated when custom field is used for estimation with no incomplete estimated issues", function () {

        GH.EpicConfig.epicConfig = {};
        GH.EpicConfig.epicConfig.epicLinkFieldName = "Epic Link";

        GH.EpicReportController.rapidViewConfig = {
            estimationStatistic: {
                typeId: "field",
                fieldId: "customfield_10020",
                name: "Story Points"
            }
        };

        GH.EpicReport.createModel();
        var model = GH.EpicReport.model;

        model.data = {
            epic: {
                key: "GHS-1"
            },
            contents: {
                incompleteUnestimatedIssues: [],
                incompleteEstimatedIssues: [],
                completeIssues: []
            },
            doneStatuses: [{ name: "Done" }],
            notDoneStatuses: [{ name: "In Progress" }, { name: "To Do" }]
        };

        model.generateJql();

        equal(model.jql.completedIssues, '"Epic Link" = "GHS-1" AND Status IN ("Done")');
        equal(model.jql.incompleteEstimatedIssues, undefined);
        equal(model.jql.incompleteUnestimatedIssues, '"Epic Link" = "GHS-1" AND Status IN ("In Progress","To Do") AND cf[10020] IS EMPTY');
    });

    test("JQL links correctly generated when custom field is used for estimation with incomplete estimated issues", function () {

        GH.EpicConfig.epicConfig = {};
        GH.EpicConfig.epicConfig.epicLinkFieldName = "Epic Link";

        GH.EpicReportController.rapidViewConfig = {
            estimationStatistic: {
                typeId: "field",
                fieldId: "customfield_10020",
                name: "Story Points"
            }
        };

        GH.EpicReport.createModel();
        var model = GH.EpicReport.model;
        model.data = {
            epic: {
                key: "GHS-1"
            },
            contents: {
                incompleteEstimatedIssues: GH.IssueTest.issueObjectsFromKeys(['ABC-1', 'ABC-2', 'ABC-3']),
                incompleteUnestimatedIssues: GH.IssueTest.issueObjectsFromKeys(['ABC-4', 'ABC-5']),
                completeIssues: []
            },
            doneStatuses: [{ name: "Done" }],
            notDoneStatuses: [{ name: "In Progress" }, { name: "To Do" }]
        };

        model.generateJql();

        equal(model.jql.completedIssues, '"Epic Link" = "GHS-1" AND Status IN ("Done")');
        equal(model.jql.incompleteUnestimatedIssues, '"Epic Link" = "GHS-1" AND Status IN ("In Progress","To Do") AND cf[10020] IS EMPTY');
        equal(model.jql.incompleteEstimatedIssues, 'issueKey in (ABC-1,ABC-2,ABC-3)');
    });

    test("JQL links correctly generated when issue count is used for estimation", function () {
        GH.EpicConfig.epicConfig = {};
        GH.EpicConfig.epicConfig.epicLinkFieldName = "Epic Link";

        GH.EpicReportController.rapidViewConfig = {
            estimationStatistic: {
                typeId: "issueCount",
                name: "Issue Count"
            }
        };

        GH.EpicReport.createModel();
        var model = GH.EpicReport.model;
        model.data = {
            epic: {
                key: "GHS-1"
            },
            doneStatuses: [{ name: "Done" }],
            notDoneStatuses: [{ name: "In Progress" }, { name: "To Do" }]
        };

        model.generateJql();

        equal(model.jql.completedIssues, '"Epic Link" = "GHS-1" AND Status IN ("Done")');
        equal(model.jql.incompleteEstimatedIssues, '"Epic Link" = "GHS-1" AND Status IN ("In Progress","To Do")');
        equal(model.jql.incompleteUnestimatedIssues, undefined);
    });

    module("calculation of series");

    test("series correctly generated for issue count", function () {
        GH.EpicReportController.rapidViewConfig = {
            estimationStatistic: {
                typeId: "issueCount"
            }
        };

        GH.EpicReport.createModel();
        var model = GH.EpicReport.model;
        model.setRawEpicChartData(GH.AjaxTest.Data.EpicProgressChartWithStoryPoints);

        var allSeries = model.getSeries();
        equal(allSeries.length, 3);

        var issueCountSeries = allSeries[0],
            completedSeries = allSeries[1];

        equal(issueCountSeries.id, "totalEstimate");
        equal(completedSeries.yaxis, 1);
        equal(completedSeries.id, "completedEstimate");
        equal(completedSeries.yaxis, 1);
    });

    test("series correctly generated for other estimation statistic", function () {
        GH.EpicReportController.rapidViewConfig = {
            estimationStatistic: {
                typeId: "field",
                fieldId: "customfield_10002"
            }
        };

        GH.EpicReport.createModel();
        var model = GH.EpicReport.model;
        model.setRawEpicChartData(GH.AjaxTest.Data.EpicProgressChartWithStoryPoints);

        var allSeries = model.getSeries();
        equal(allSeries.length, 5);

        var issueCountSeries = allSeries[2],
            unestimatedSeries = allSeries[3],
            totalSeries = allSeries[0],
            completedSeries = allSeries[1];

        equal(issueCountSeries.id, "issueCount");
        equal(issueCountSeries.yaxis, 2);
        equal(unestimatedSeries.id, "unestimatedIssueCount");
        equal(unestimatedSeries.yaxis, 2);
        equal(totalSeries.id, "totalEstimate");
        equal(totalSeries.yaxis, 1);
        equal(completedSeries.id, "completedEstimate");
        equal(completedSeries.yaxis, 1);
    });

    test("JQL links correctly generated when Original Time Estimate is used for estimation", function () {
        GH.EpicConfig.epicConfig = {};
        GH.EpicConfig.epicConfig.epicLinkFieldName = "Epic Link";

        GH.EpicReportController.rapidViewConfig = {
            estimationStatistic: {
                typeId: "field",
                fieldId: "timeoriginalestimate",
                name: "Original Time Estimate"
            }
        };

        GH.EpicReport.createModel();
        var model = GH.EpicReport.model;
        model.data = {
            epic: {
                key: "GHS-1"
            },
            doneStatuses: [{ name: "Done" }],
            notDoneStatuses: [{ name: "In Progress" }, { name: "To Do" }]
        };

        model.generateJql();
        var jql = model.getJql();

        equal(jql.completedIssues, '"Epic Link" = "GHS-1" AND Status IN ("Done")');
        equal(jql.incompleteEstimatedIssues, '"Epic Link" = "GHS-1" AND Status IN ("In Progress","To Do") AND timeoriginalestimate IS NOT EMPTY');
        equal(jql.incompleteUnestimatedIssues, '"Epic Link" = "GHS-1" AND Status IN ("In Progress","To Do") AND timeoriginalestimate IS EMPTY');
    });

    test("Epic model is correctly built", function () {

        GH.EpicConfig.epicConfig = {};
        GH.EpicConfig.epicConfig.epicLinkFieldName = "Epic Link";

        GH.EpicReportController.rapidViewConfig = {
            estimationStatistic: {
                name: "Story Points",
                typeId: "field"
            }
        };

        GH.EpicReport.createModel();
        var model = GH.EpicReport.model;
        model.setRawData(GH.AjaxTest.Data.EpicReportWithStoryPoints);

        // check we set the contents - used in the view
        var content = model.getReportContent();
        equal(content, GH.AjaxTest.Data.EpicReportWithStoryPoints.contents, "Contents is set");

        // check all the issues have an estimate
        var issuesWithNoEstimateText = _.find(content.completedIssues, function (issue) {
            return _.isUndefined(issue.estimateStatistic.statFieldValue.text);
        });
        ok(_.isEmpty(issuesWithNoEstimateText), "No completed issues are missing an estimate");
        issuesWithNoEstimateText = _.find(content.incompleteUnestimatedIssues, function (issue) {
            return _.isUndefined(issue.estimateStatistic.statFieldValue.text);
        });
        ok(_.isEmpty(issuesWithNoEstimateText), "No unestimated issues are missing estimate text");
        issuesWithNoEstimateText = _.find(content.incompleteEstimatedIssues, function (issue) {
            return _.isUndefined(issue.estimateStatistic.statFieldValue.text);
        });
        ok(_.isEmpty(issuesWithNoEstimateText), "No incomplete issues are missing estimate text");

        // check that we removed the decimal (Story Point estimates)
        equal(content.completedIssuesEstimateSum.text, "13", "13 story points are completed");
        equal(content.incompletedIssuesEstimateSum.text, "16", "16 story points remaining");

        // check summary
        var summary = model.getEpicSummary();
        equal(summary.epicStats.done, 4, "Has 4 completed issues");
        equal(summary.epicStats.notEstimated, 0, "Has 0 unestimated issues");
        equal(summary.epicStats.totalIssueCount, 10, "Has 10 issues in total");
        equal(summary.estimateDone, 13, "Has 13 complete story points");
        equal(summary.estimateTotal, 29, "Has 29 story points in total");
        equal(summary.estimateStatisticName, "Story Points");

        // check we built jql - other tests check content
        var jql = model.getJql();
        ok(jql.completedIssues);
        ok(jql.allIssues);
        ok(jql.incompleteEstimatedIssues);
        ok(jql.incompleteUnestimatedIssues);
    });

    module("hasIssues", {
        setup: function setup() {
            GH.EpicReportController.rapidViewConfig = {
                estimationStatistic: {
                    typeId: "field",
                    fieldId: "customfield_10020",
                    name: "Story Points"
                }
            };
        }
    });

    test("Has content but no issues", sinon.test(function () {
        GH.EpicConfig.epicConfig = {
            epicLinkFieldName: "Epic Link"
        };
        GH.EpicReport.createModel();
        var model = GH.EpicReport.model;
        model.setRawData(GH.AjaxTest.Data.EpicReportWithNoStories);
        ok(!model.hasIssues());
    }));

    test("Has content and issues", sinon.test(function () {
        GH.EpicReport.createModel();
        var model = GH.EpicReport.model;
        model.setRawData(GH.AjaxTest.Data.EpicReportWithStoryPoints);
        ok(model.hasIssues());
    }));

    test("Has no content but issues in changes", sinon.test(function () {
        GH.EpicReport.createModel();
        var model = GH.EpicReport.model;
        model.setRawEpicChartData(GH.AjaxTest.Data.EpicProgressChartWithStoryPoints);
        ok(model.hasIssues());
    }));
});