GH.EpicReportView = {};

GH.EpicReportView.setUserTimeZoneLabel = function (userTimeZoneLabel) {
    GH.EpicReportView.userTimeZoneLabel = userTimeZoneLabel;
};

GH.EpicReportView.renderChartLoading = function () {
    // render the skeleton for the view
    GH.ChartView.getChartContentElem(true).html(GH.tpl.epicreport.renderReportBody());

    // show the spinner
    GH.ChartView.showSpinner();
};

GH.EpicReportView.toggleChartVisibility = function () {
    GH.ChartView.hideSpinner();
    AJS.$('#ghx-chart-mismatch').empty();
    if (GH.EpicReport.model.hasIssues()) {
        AJS.$('#ghx-epic-report-no-issues').hide();
        AJS.$("#ghx-report-content").show();
    } else {
        AJS.$("#ghx-report-content").hide();
        AJS.$('#ghx-epic-report-no-issues').show();
    }
};

GH.EpicReportView.renderReport = function () {
    GH.EpicReportView.toggleChartVisibility();

    // renders key / summary, only available in the report rest data
    GH.EpicReportView.renderMeta();

    if (GH.EpicReport.model.hasIssues()) {
        GH.EpicReportView.renderIssuesReport();
        GH.EpicReportView.renderSummary();
    }
};

GH.EpicReportView.renderEpicPicker = function () {
    GH.EpicReportController.epicPicker.render(GH.ChartView.getChartSelector(true));
};

GH.EpicReportView.renderIssuesReport = function () {
    var content = GH.EpicReport.model.getReportContent();
    var hasIssues = GH.EpicReport.model.hasIssues();
    var $epicReport = AJS.$('#ghx-report-content .ghx-epic-report');

    $epicReport.empty().html(GH.tpl.epicreport.renderEpicReport({
        content: content,
        jql: GH.EpicReport.model.getJql(),
        estimationStatistic: GH.EpicReportController.rapidViewConfig.estimationStatistic,
        hasIssues: hasIssues
    }));

    $epicReport.find(".issue-table-title-tooltip").tooltip();
};

GH.EpicReportView.renderSummary = function () {
    AJS.$('#ghx-report-content .ghx-epic-summary').empty().html(GH.tpl.epicreport.renderEpicSummary({
        epic: GH.EpicReport.model.getEpicSummary(),
        issuesJql: GH.EpicReport.model.getJql().allIssues
    }));
};

GH.EpicReportView.renderMeta = function () {
    var epic = GH.EpicReport.model.getEpic();
    AJS.$('#ghx-epic-meta').empty().append(GH.tpl.epicreport.renderEpicReportHeader({
        epic: epic,
        showPages: GH.EpicReport.model.supportsPages()
    })).show();
    GH.LinkedPagesController.initDialogTrigger(GH.LinkedPagesController.EPIC, GH.LinkedPagesController.REPORT, epic.id, AJS.$('#ghx-epic-meta .js-view-entity-pages'));
};

GH.EpicReportView.renderStatisticMismatchWarning = function (issues) {
    var keys = _.pluck(issues, 'key');

    var errorMessage = GH.tpl.epicreport.renderStatisticValueMismatchMessage({
        statisticName: GH.EpicReport.model.getStatistic().name,
        keys: keys.join(', ')
    });

    AJS.messages.warning('#ghx-chart-mismatch', {
        body: errorMessage,
        closeable: true,
        shadowed: false
    });
};

GH.EpicReportView.renderChart = function () {
    var Chart = require('jira-agile/rapid/ui/chart/chart');

    GH.EpicReportView.toggleChartVisibility();

    if (GH.EpicReport.model.hasIssues()) {
        // element that holds the actual chart - do not use cached element
        var plotHolder = GH.ChartView.getChartView(true);
        var series = GH.EpicReport.model.getSeries();

        // plot the series
        var plot = Chart.draw(GH.EpicReportController.id, plotHolder, series, GH.ChartUtils.getChartOptions(GH.EpicReport.model));

        var secondYAxisLabel = false;
        if (GH.EpicReport.model.getYAxes().length > 1) {
            secondYAxisLabel = AJS.I18n.getText('gh.rapid.charts.progress.issuecount');
        }
        GH.FlotChartUtils.setAndAlignAxisLabels(AJS.I18n.getText('gh.rapid.charts.progress.xaxis.label', GH.EpicReportView.userTimeZoneLabel), GH.EpicReport.model.getStatistic().name, secondYAxisLabel);

        // register hooks to handle dot painting
        plot.hooks.drawSeries.push(GH.EpicReportView.gatherPoints);
        plot.hooks.draw.push(GH.FlotChartUtils.deferredRenderPoints);

        GH.EpicReportView.bindEvents(plotHolder);
    }
};

// Tooltip support

/**
 * Handler for  plot hover events.
 */
GH.EpicReportView.handlePlotHover = function (event, pos, item) {
    // fetch the issue for that index
    if (item) {
        // fetch the data for the given point
        var seriesId = item.series.id;
        var dataIndex = item.dataIndex;
        var dataPoint = GH.EpicReport.model.getDataBySeriesAtIndex(seriesId, dataIndex);

        if (!_.isEmpty(dataPoint)) {
            if (GH.EpicReportView.previousPlotHoverPoint != item.dataIndex) {
                GH.EpicReportView.previousPlotHoverPoint = item.dataIndex;

                // remove the previous tooltip and add a new one
                AJS.$("#ghx-tooltip").remove();
                GH.EpicReportView.showChartTooltip(item, seriesId, dataPoint, item.datapoint[0]);

                // if the tooltip has no warnings then the issue is clickable
                if (!AJS.$("#ghx-tooltip").hasClass("ghx-has-warnings")) {
                    GH.ChartView.getChartView().addClass("ghx-clickable");
                }
            }
            return;
        }
    }
    AJS.$("#ghx-tooltip").remove();
    GH.EpicReportView.previousPlotHoverPoint = null;
    GH.ChartView.getChartView().removeClass('ghx-clickable');
};

/**
 * Displays a data point tooltip
 */
GH.EpicReportView.showChartTooltip = function (item, seriesId, dataPoint) {
    if (!dataPoint) {
        return;
    }

    // render the tooltip
    var tooltipData = GH.EpicReport.model.getTooltipData(seriesId, dataPoint);
    var tooltip = new GH.ChartTooltip(item, tooltipData);
    tooltip.render();
};

/** Holds the last hovered point. */
GH.EpicReportView.previousPlotHoverPoint = undefined;

/**
 * Gather the data points we want to draw
 *
 * @param plot : the chart object
 * @param ctx : the canvas 2d context
 * @param series : series currently being drawn
 */
GH.EpicReportView.gatherPoints = function (plot, ctx, series) {
    // Don't add data points when mouse is outside of the plot
    if (!plot.mouseEntered) {
        return;
    }

    GH.EpicReportController.setPointsForChart(plot, series);
};

GH.EpicReportView.bindEvents = function (plotHolder) {
    // mouse enter/leave events
    plotHolder.unbind('flotMouseEnter flotMouseLeave').bind('flotMouseEnter flotMouseLeave', GH.FlotChartUtils.handleMouseOverStateChange);

    // register plothover and plotclick event handlers
    // we first unbind here, otherwise we add on each invocation a new click handler
    plotHolder.unbind("plothover plotclick");
    plotHolder.bind("plothover", GH.EpicReportView.handlePlotHover);
    plotHolder.bind("plotclick", GH.FlotChartUtils.handlePlotClick);
};