AJS.test.require(["com.pyxis.greenhopper.jira:gh-test-common", "com.pyxis.greenhopper.jira:gh-rapid"], function() {
    var BurndownRate = require('jira-agile/rapid/ui/chart/burndown-rate');
    var ReleaseDatePredictor = require('jira-agile/rapid/ui/chart/release-date-predictor');
    var VersionReportController = require('jira-agile/rapid/ui/chart/version-report-controller');

    module("series calculation", {
        setup: function() {
            VersionReportController.rapidViewConfig = {
                estimationStatistic: {
                    typeId: "field",
                    fieldId: "customfield_10002"
                }
            };
        }
    });

    test('module "jira-agile/rapid/ui/chart/release-date-predictor" exists', function() {
        ok(ReleaseDatePredictor);
        ok(GH.ReleaseDatePredictor);
    });

    test("calculation of completed points per day for predictions", sinon.test(function() {

        this.stub(BurndownRate, "isDateInNonWorkingBlock").returns(false);
        // This data starts from Feb 12
        // Finishes on Feb 27
        var startTime = new Date(2013,1,12,9,30).valueOf();
        var endTime = new Date(2013,1,27).valueOf();
        // Create some chart data (copied from sample data)
        var completedEstimateDataPoints = [
            [new Date(2013, 1, 12, 10).valueOf(), 0],
            [new Date(2013, 1, 12, 10).valueOf(), 3],
            [new Date(2013, 1, 16, 10).valueOf(), 3],
            [new Date(2013, 1, 16, 10).valueOf(),8],
            [new Date(2013, 1, 17, 10).valueOf(),8],
            [new Date(2013, 1, 17, 10).valueOf(),11],
            [new Date(2013, 1, 19, 10).valueOf(),11],
            [new Date(2013, 1, 19, 10).valueOf(),12],
            [new Date(2013, 1, 22, 10).valueOf(),12],
            [new Date(2013, 1, 22, 10).valueOf(),14],
            [new Date(2013, 1, 24, 10).valueOf(),14],
            [new Date(2013, 1, 24, 10).valueOf(),16],
            [new Date(2013, 1, 27, 10).valueOf(),16]];

        var estimatePerDay = ReleaseDatePredictor.getCompletedEstimatePerDay(completedEstimateDataPoints, startTime, endTime, []);

        equal(estimatePerDay.completedData.length, 15);
        equal(estimatePerDay.workingDays, 15);

        equal(estimatePerDay.completedData[0].estimate, 0);
        equal(estimatePerDay.completedData[1].estimate, 3);
        equal(estimatePerDay.completedData[2].estimate, 0);
        equal(estimatePerDay.completedData[3].estimate, 0);
        equal(estimatePerDay.completedData[4].estimate, 0);
        equal(estimatePerDay.completedData[5].estimate, 5);
        equal(estimatePerDay.completedData[6].estimate, 3);
        equal(estimatePerDay.completedData[7].estimate, 0);
        equal(estimatePerDay.completedData[8].estimate, 1);
        equal(estimatePerDay.completedData[9].estimate, 0);
        equal(estimatePerDay.completedData[10].estimate, 0);
        equal(estimatePerDay.completedData[11].estimate, 2);
        equal(estimatePerDay.completedData[12].estimate, 0);
        equal(estimatePerDay.completedData[13].estimate, 2);
        equal(estimatePerDay.completedData[14].estimate, 0);
    }));

    test("calculation of deviation of points", sinon.test(function() {

        equal(ReleaseDatePredictor.calculateDeviation(3).toFixed(2), 0.30);
    }));

    test("calculation of average points per day", sinon.test(function() {

        var estimatePerDay = {
            completedData: [
                {
                    estimate: 0
                },
                {
                    estimate: 3
                },
                {
                    estimate: 7
                },
                {
                    estimate: 2
                }
            ],
            workingDays: 4
        };

        equal(ReleaseDatePredictor.calculateAverageEstimateCompletedPerDay(estimatePerDay), 3);
    }));

    var startDate = new Date(2013, 1, 4).valueOf(); // Monday Feb 4
    var endDate = new Date(2013, 1, 15).valueOf(); // Friday, Feb 15
    var startWeekend = new Date(2013, 1, 9).valueOf(); // Saturday, Feb 9
    var endWeekend = new Date(2013, 1, 11).valueOf(); // Monday, Feb 11

    var workRates = [
        { start: startDate, end: startWeekend, rate: 1 },
        { start: endWeekend, end: endDate, rate: 1 }
    ];

    test("returns empty when no working days at all ", sinon.test(function() {
        var options = {
            startDate: new Date(2013, 1, 6).valueOf(),
            estimatePerDay: 1,
            totalCompleted: 0,
            totalScope: 10
        };

        this.stub(BurndownRate, "getWorkingDays").returns([]);

        var series = ReleaseDatePredictor.createDataSeries(options);

        deepEqual(series, []);
    }));

    test("returns Infinity end date when points per day is 0 ", sinon.test(function() {
        var options = {
            startDate: new Date(2013, 1, 6).valueOf(),
            estimatePerDay: 0,
            totalCompleted: 0,
            totalScope: 10
        };

        this.stub(BurndownRate, "getWorkingDays").returns(workRates);

        var series = ReleaseDatePredictor.createDataSeries(options);

        equal(series.length, 2);
        deepEqual(series[0], [options.startDate, 0]);
        deepEqual(series[1], [Infinity, 0]);
    }));

    test("calculates correct series when all work is done within first working block", sinon.test(function() {
        var options = {
            startDate: new Date(2013, 1, 5).valueOf(),
            estimatePerDay: 1,
            totalCompleted: 0,
            totalScope: 3
        };

        this.stub(BurndownRate, "getWorkingDays").returns(workRates);

        var expectedEndDate = options.startDate + (3 * GH.ChartUtils.oneDayInMillis);

        var series = ReleaseDatePredictor.createDataSeries(options);

        equal(series.length, 2);
        deepEqual(series[0], [options.startDate, 0]);
        deepEqual(series[1], [expectedEndDate, 3]);
    }));

    test("ignores working blocks that occur before the chart start date", sinon.test(function() {
        var options = {
            startDate: new Date(2013, 1, 12).valueOf(),
            estimatePerDay: 1,
            totalCompleted: 0,
            totalScope: 3
        };

        this.stub(BurndownRate, "getWorkingDays").returns(workRates);

        var expectedEndDate = options.startDate + (3 * GH.ChartUtils.oneDayInMillis);

        var series = ReleaseDatePredictor.createDataSeries(options);

        equal(series.length, 2);
        deepEqual(series[0], [options.startDate, 0]);
        deepEqual(series[1], [expectedEndDate, 3]);
    }));

    test("correctly calculates prediction across multiple non-working day blocks", sinon.test(function() {
        var options = {
            startDate: new Date(2013, 1, 5).valueOf(),
            estimatePerDay: 1,
            totalCompleted: 1,
            totalScope: 8
        };

        this.stub(BurndownRate, "getWorkingDays").returns(workRates);

        var expectedEndDate = new Date(2013, 1, 14);

        var series = ReleaseDatePredictor.createDataSeries(options);

        equal(series.length, 2);
        deepEqual(series[0], [options.startDate, 1]);
        deepEqual(series[1], [expectedEndDate.valueOf(), 8]);
    }));
});