AJS.test.require(["com.pyxis.greenhopper.jira:gh-test-common", "com.pyxis.greenhopper.jira:gh-rapid"], function () {
    module("Sprint Report", {
        setup: function setup() {
            GH.Test.setUpFakeServer(this);
            GH.SprintRetrospectiveController.sprintPicker = {
                getSelectedItem: function getSelectedItem() {
                    return { id: 1 };
                }
            };
            GH.SprintRetrospectiveController.displayed = true;
        },
        teardown: function teardown() {
            GH.Test.restoreServer(this);
        }
    });

    test("loadSprintOptions: successful Ajax request passes to process sprint data", sinon.test(function () {
        this.stub(GH.SprintRetrospectiveController, "processSprintsData");

        GH.Test.respondToGetWith200(this, "/sprintquery/", {});

        GH.SprintRetrospectiveController.loadSprintOptions();

        this.server.respond();

        ok(GH.SprintRetrospectiveController.processSprintsData.called, "Called success method");
    }));

    test("loadSprintOptions: failed Ajax request does nothing (no specific error handler)", sinon.test(function () {
        this.stub(GH.SprintRetrospectiveController, "processSprintsData");

        GH.Test.respondToGetWith500(this, "/sprintquery/", {});

        GH.SprintRetrospectiveController.loadSprintOptions();

        this.server.respond();

        ok(!GH.SprintRetrospectiveController.processSprintsData.called, "Does not call process function on failure");
    }));

    test("loadReportData: successful Ajax requests passes to process sprint report data", sinon.test(function () {
        this.stub(GH.SprintRetrospectiveController, "processReportData");
        this.stub(GH.SprintRetrospectiveView, "showMiniBurndown");

        GH.Test.respondToGetWith200(this, "rapid/charts/sprintreport", {});
        GH.Test.respondToGetWith200(this, "/rapid/charts/scopechangeburndownchart.json", {});

        GH.SprintRetrospectiveController.loadReportData();

        this.server.respond();

        ok(GH.SprintRetrospectiveController.processReportData.called, "Called process report data");
        ok(GH.SprintRetrospectiveView.showMiniBurndown.called, "Called show mini burndown");
    }));

    test("loadSprintOptions: failed Ajax request hides spinner", sinon.test(function () {
        this.stub(GH.SprintRetrospectiveController, "processReportData");
        this.stub(GH.SprintRetrospectiveView, "showMiniBurndown");
        this.stub(GH.ChartView, "hideSpinner");

        GH.Test.respondToGetWith500(this, "rapid/charts/sprintreport", {});
        GH.Test.respondToGetWith500(this, "/rapid/charts/scopechangeburndownchart.json", {});

        GH.SprintRetrospectiveController.loadReportData();

        this.server.respond();

        ok(!GH.SprintRetrospectiveController.processReportData.called, "Does not call process function on failure");
        ok(!GH.SprintRetrospectiveView.showMiniBurndown.called, "Does not call show burndown function on failure");
        ok(GH.ChartView.hideSpinner.called, "Hid Spinner");
    }));

    test("shouldShowCreateRetroDialog: user has not come from sprint complete, returns true", sinon.test(function () {
        this.stub(GH.SprintRetrospectiveController, "getSprintsMarkedForRetroDialog").returns([]);

        equal(GH.SprintRetrospectiveController.shouldShowCreateRetroDialog(0), false, "Dialog shows");
    }));

    test("shouldShowCreateRetroDialog: user has come from complete sprint, returns true", sinon.test(function () {
        this.stub(GH.SprintRetrospectiveController, "getSprintsMarkedForRetroDialog").returns([{ sprintId: 1, dismissed: false }]);

        equal(GH.SprintRetrospectiveController.shouldShowCreateRetroDialog(1), true, "Dialog shows");
    }));

    test("shouldShowCreateRetroDialog: sprint marked to show dialog but already dismissed, returns false", sinon.test(function () {
        this.stub(GH.SprintRetrospectiveController, "getSprintsMarkedForRetroDialog").returns([{ sprintId: 1, dismissed: true }]);

        equal(GH.SprintRetrospectiveController.shouldShowCreateRetroDialog(1), false, "Dialog does not show");
    }));

    test("SW-1699: getAppLinkData() should not cause js error and should return null appLinkUrl when there is no available application link", sinon.test(function () {
        GH.Test.respondToGetWith200(this, '/sprint/1/pages', { pages: [], applicationLinks: [] });

        var promise = GH.LinkedPagesController.getLinkedPagesForEntity(GH.LinkedPagesController.SPRINT, 1);
        this.stub(GH.LinkedPagesController, 'getLinkedPagesForEntity').returns(promise);
        GH.SprintRetrospectiveController.getAppLinkData().done(function (appLinkData) {
            equal(appLinkData.appLinkUrl, null, 'appLinkUrl is null when there is no available application link');
        });

        this.server.respond();
    }));
});