/**
 * Version Report
 * @module jira-agile/rapid/ui/chart/version-report
 * @requires module:jira-agile/rapid/ui/chart/version-report-model
 */
define('jira-agile/rapid/ui/chart/version-report', ['require'], function (require) {
    'use strict';

    // REQUIRES

    var VersionReportModel = require('jira-agile/rapid/ui/chart/version-report-model');

    var VersionReport = {};

    VersionReport.createModel = function (estimationStatistic) {
        VersionReport.model = new VersionReportModel(estimationStatistic);
        VersionReport.model.setParams({
            statistic: estimationStatistic,
            issueAddedText: AJS.I18n.getText('gh.rapid.charts.version.event.scope.change.detail.issue.added'),
            issueRemovedText: AJS.I18n.getText('gh.rapid.charts.version.event.scope.change.detail.issue.removed'),
            startText: AJS.I18n.getText('gh.rapid.charts.version.event.start')
        });
    };

    return VersionReport;
});