GH.Reports = GH.Reports || {};

/**
 * A c3 component for rendering an array of unique charts into existing containers.
 * The charts are an array of c3 components (or functions that accept a d3 selection as their first argument).
 * The containers are found by looking up a single CSS selector.
 */
GH.Reports.multipleCharts = function () {
    return c3.component('multipleCharts').extend({
        charts: c3.prop([]),
        chartSelector: c3.prop('.ghx-svg-chart')
    }).extend(function () {
        this.selection().selectAll(this.chartSelector()).data(this.charts()).each(function (d) {
            if (d) {
                d(d3.select(this));
            }
        });
    });
};