(function (d3, c3, _, Reports) {

    function ScopeBurndownBySprintChartHowTo() {
        var simpleScopeStack = function simpleScopeStack() {
            return c3.floatingBarChart().elementClass('ghx-bar-sprint').elementTag('g').yAccessor(function (d) {
                return d[0] + _.reduce(d[1], function (total, value) {
                    return total + value;
                }, 0);
            }).yDomain([-1, 9]) // easier than padding a c3.borderLayout :)
            .update(function (event) {
                var _barWidth = this.barWidth();
                var height = this.barHeight();
                event.selection.each(function (d) {
                    c3.stack().classPrefix('ghx').height(height(d)).extend({
                        barWidth: function barWidth() {
                            return _barWidth;
                        },
                        data: function data() {
                            var s = d[1];
                            return [[s[0] + s[1], s[2]], [s[0], s[1]], [0, s[0]]];
                        }
                    })(d3.select(this));
                });
            });
        };

        var progress = simpleScopeStack().data([[0, [0, 8, 0]], [0, [0, 6, 2]], [0, [0, 4, 2]], [0, [0, 2, 2]], [0, [0, 0, 2]]]);

        var scopeChange = simpleScopeStack().data([[2, [0, 6, 0]], [0, [2, 4.5, 1.5]], [0, [0, 5, 1.5]], [2, [0, 1.5, 1.5]], [2, [0, 0, 1.5]]]);

        var prediction = simpleScopeStack().data([[0, [0, 6, 1.5]], [0, [0, 4.5, 1.5]], [0, [0, 3, 1.5]], [0, [0, 1.5, 1.5]], [0, [0, 0, 1.5]]]).update(function (event) {
            event.selection.classed('ghx-prediction', function (d, i) {
                return i >= 2;
            });
        });

        return c3.component('scopeBurndownBySprintChartHowTo').extend(Reports.multipleCharts()).extend(function () {
            this.selection().selectAll(this.chartSelector()).classed('ghx-scope-burndown-chart-svg', true);
        }).charts([progress, scopeChange, prediction]);
    }

    Reports.ScopeBurndownBySprintChartHowTo = ScopeBurndownBySprintChartHowTo;
})(d3, c3, _, GH.Reports);