AJS.test.require("com.pyxis.greenhopper.jira:gh-rapid",function(){module("ScopeBurndownBySprintTransformer tests",{setup:function(){this.service=GH.Reports.ScopeBurndownBySprintTransformer},makeSprints:function(e){var t=100;return _.map(_.range(1,1+e),function(e){return{id:e,name:"Sprint "+e,startTime:e*t,endTime:(e+1)*t,state:"CLOSED"}})},addToScopeBurndown:function(e){return{key:e,added:!0}},removeFromScopeBurndown:function(e){return{key:e,added:!1}},moveToDone:function(e){return{key:e,column:{notDone:!1}}},moveToNotDone:function(e){return{key:e,column:{notDone:!0}}},changeEstimate:function(e,t){return{key:e,statC:{newValue:t}}},addAndEstimate:function(e,t){return[_.extend(this.moveToNotDone(e),this.changeEstimate(e,t),this.addToScopeBurndown(e))]},getOriginalEstimateSprintName:function(){return"Original estimate"}}),test("Typical data",function(){var e={sprints:this.makeSprints(3),changes:{1:[this.moveToNotDone("TEST-1"),this.moveToNotDone("TEST-2"),this.moveToNotDone("TEST-3")],2:[this.changeEstimate("TEST-1",5)],3:[this.changeEstimate("TEST-2",3),this.changeEstimate("TEST-3",0)],10:[this.addToScopeBurndown("TEST-1"),this.addToScopeBurndown("TEST-2"),this.addToScopeBurndown("TEST-3")],100:[this.moveToDone("TEST-1")],200:[this.moveToDone("TEST-2")],299:[this.moveToNotDone("TEST-4"),this.addToScopeBurndown("TEST-4"),this.changeEstimate("TEST-4",8)],300:[this.moveToDone("TEST-3")]},labels:{originalEstimate:this.getOriginalEstimateSprintName()},estimatableIssueKeys:["TEST-1","TEST-2","TEST-3","TEST-4"]},t=this.service.getScopeBySprintData(e);deepEqual(t.sprints,[{sprintId:"original",sprintName:this.getOriginalEstimateSprintName(),baseline:0,workAtStart:8,workAdded:0,workRemoved:0,workCompleted:0,workRemaining:8,isForecast:!1,isActive:!1,issues:[]},{sprintId:1,sprintName:"Sprint 1",baseline:0,workAtStart:8,workAdded:0,workRemoved:0,workCompleted:5,workRemaining:3,startTime:100,endTime:200,isForecast:!1,isActive:!1,issues:["TEST-1"]},{sprintId:2,sprintName:"Sprint 2",baseline:-8,workAtStart:3,workAdded:8,workRemoved:0,workCompleted:3,workRemaining:8,startTime:200,endTime:300,isForecast:!1,isActive:!1,issues:["TEST-2"]},{sprintId:3,sprintName:"Sprint 3",baseline:-8,workAtStart:8,workAdded:0,workRemoved:0,workCompleted:0,workRemaining:8,startTime:300,endTime:400,isForecast:!1,isActive:!1,issues:["TEST-3"]}]),deepEqual(t.forecast,{sprintsRemaining:3,workRemaining:8,velocity:3,baseline:-8,isLastSprintForecast:!1}),deepEqual(t.snapshot,{workRemaining:8,estimatedIssueCount:4,estimatableIssueCount:4,issueCount:4,workCompleted:8})}),test("No sprints, no changes",function(){var e={sprints:[],changes:{},labels:{originalEstimate:this.getOriginalEstimateSprintName()},estimatableIssueKeys:[]},t=this.service.getScopeBySprintData(e);deepEqual(t.sprints,[{sprintId:"original",sprintName:this.getOriginalEstimateSprintName(),baseline:0,workAtStart:0,workAdded:0,workRemoved:0,workCompleted:0,workRemaining:0,isForecast:!1,isActive:!1,issues:[]}]),deepEqual(t.snapshot,{workRemaining:0,estimatedIssueCount:0,issueCount:0,workCompleted:0,estimatableIssueCount:0})}),test("No sprints, only estimated issues in ScopeBurndown",function(){var e={sprints:[],labels:{originalEstimate:this.getOriginalEstimateSprintName()},changes:{1:this.addAndEstimate("TEST-1",3),2:this.addAndEstimate("TEST-2",5)},estimatableIssueKeys:["TEST-1","TEST-2"]},t=this.service.getScopeBySprintData(e);deepEqual(t.sprints,[{sprintId:"original",sprintName:this.getOriginalEstimateSprintName(),baseline:0,workAtStart:8,workAdded:0,workRemoved:0,workCompleted:0,workRemaining:8,isForecast:!1,isActive:!1,issues:[]}]),deepEqual(t.snapshot,{workRemaining:8,estimatedIssueCount:2,issueCount:2,workCompleted:0,estimatableIssueCount:2})}),test("Work done before first sprint",function(){var e={sprints:this.makeSprints(10),changes:{1:this.addAndEstimate("TEST-1",3),2:this.addAndEstimate("TEST-2",5),3:[this.moveToDone("TEST-1")]},labels:{originalEstimate:this.getOriginalEstimateSprintName()},estimatableIssueKeys:["TEST-1","TEST-2"]},t=this.service.getScopeBySprintData(e);deepEqual(t.sprints,[{sprintId:"original",sprintName:this.getOriginalEstimateSprintName(),baseline:0,workAtStart:8,workAdded:0,workRemoved:0,workCompleted:3,workRemaining:5,isForecast:!1,isActive:!1,issues:["TEST-1"]}]),deepEqual(t.snapshot,{workRemaining:5,estimatedIssueCount:2,issueCount:2,workCompleted:3,estimatableIssueCount:2})}),test("Removing all work from ScopeBurndown without doing anything",function(){var e={sprints:this.makeSprints(2),changes:{1:this.addAndEstimate("TEST-1",3),2:this.addAndEstimate("TEST-2",3),3:this.addAndEstimate("TEST-3",3),4:this.addAndEstimate("TEST-4",3),100:[this.removeFromScopeBurndown("TEST-1")],101:[this.removeFromScopeBurndown("TEST-2")],200:[this.removeFromScopeBurndown("TEST-3")],201:[this.removeFromScopeBurndown("TEST-4")]},labels:{originalEstimate:this.getOriginalEstimateSprintName()},estimatableIssueKeys:["TEST-1","TEST-2","TEST-3","TEST-4"]},t=this.service.getScopeBySprintData(e);deepEqual(t.sprints,[{sprintId:"original",sprintName:this.getOriginalEstimateSprintName(),baseline:0,workAtStart:0,workAdded:0,workRemoved:0,workCompleted:0,workRemaining:0,isForecast:!1,isActive:!1,issues:[]}]),deepEqual(t.snapshot,{workRemaining:0,estimatedIssueCount:0,issueCount:0,workCompleted:0,estimatableIssueCount:0})}),test("When last sprint is currently active, no remaining work sprint is returned",function(){var e=this.makeSprints(2);e[1].state="ACTIVE";var t={sprints:e,changes:{1:this.addAndEstimate("TEST-1",1),2:this.addAndEstimate("TEST-2",2),100:[this.moveToDone("TEST-1")]},labels:{originalEstimate:this.getOriginalEstimateSprintName()},estimatableIssueKeys:["TEST-1","TEST-2"]},i=this.service.getScopeBySprintData(t);deepEqual(i.sprints,[{sprintId:"original",sprintName:this.getOriginalEstimateSprintName(),baseline:0,workAtStart:3,workAdded:0,workRemoved:0,workCompleted:0,workRemaining:3,isForecast:!1,isActive:!1,issues:[]},{sprintId:1,sprintName:"Sprint 1",baseline:0,workAtStart:3,workAdded:0,workRemoved:0,workCompleted:1,workRemaining:2,startTime:100,endTime:200,isForecast:!1,isActive:!1,issues:["TEST-1"]},{sprintId:2,sprintName:"Sprint 2",baseline:0,workAtStart:2,workAdded:0,workRemoved:0,workCompleted:0,workRemaining:2,startTime:200,endTime:300,isForecast:!1,isActive:!0,issues:[]}])}),test("Changing an estimate is retroactive",function(){var e={sprints:this.makeSprints(1),changes:{1:this.addAndEstimate("TEST-1",1),100:[this.moveToDone("TEST-1")],200:[this.changeEstimate("TEST-1",3)]},labels:{originalEstimate:this.getOriginalEstimateSprintName()},estimatableIssueKeys:["TEST-1"]},t=this.service.getScopeBySprintData(e);deepEqual(t.sprints,[{sprintId:"original",sprintName:this.getOriginalEstimateSprintName(),baseline:0,workAtStart:3,workAdded:0,workRemoved:0,workCompleted:0,workRemaining:3,isForecast:!1,isActive:!1,issues:[]},{sprintId:1,sprintName:"Sprint 1",baseline:0,workAtStart:3,workAdded:0,workRemoved:0,workCompleted:3,workRemaining:0,startTime:100,endTime:200,isForecast:!1,isActive:!1,issues:["TEST-1"]}]),deepEqual(t.snapshot,{workRemaining:0,estimatedIssueCount:1,issueCount:1,workCompleted:3,estimatableIssueCount:1})}),test("Issue that is moved back to Not Done removes previous work completed",function(){var e={sprints:this.makeSprints(1),changes:{1:this.addAndEstimate("TEST-1",1),2:[this.moveToDone("TEST-1")],100:[this.moveToNotDone("TEST-1")],101:[this.moveToDone("TEST-1")]},labels:{originalEstimate:this.getOriginalEstimateSprintName()},estimatableIssueKeys:["TEST-1"]},t=this.service.getScopeBySprintData(e);deepEqual(t.sprints,[{sprintId:"original",sprintName:this.getOriginalEstimateSprintName(),baseline:0,workAtStart:1,workAdded:0,workRemoved:0,workCompleted:0,workRemaining:1,isForecast:!1,isActive:!1,issues:[]},{sprintId:1,sprintName:"Sprint 1",baseline:0,workAtStart:1,workAdded:0,workRemoved:0,workCompleted:1,workRemaining:0,startTime:100,endTime:200,isForecast:!1,isActive:!1,issues:["TEST-1"]}]),deepEqual(t.snapshot,{workRemaining:0,estimatedIssueCount:1,issueCount:1,workCompleted:1,estimatableIssueCount:1})}),test("More work is done than what was remaining in previous sprint or original estimate",function(){var e={sprints:this.makeSprints(2),changes:{100:this.addAndEstimate("TEST-1",5),101:[this.moveToDone("TEST-1")],200:this.addAndEstimate("TEST-2",8),201:this.addAndEstimate("TEST-3",13),202:[this.moveToDone("TEST-2")]},labels:{originalEstimate:this.getOriginalEstimateSprintName()},estimatableIssueKeys:["TEST-1","TEST-2","TEST-3"]},t=this.service.getScopeBySprintData(e);deepEqual(t.sprints,[{sprintId:"original",sprintName:this.getOriginalEstimateSprintName(),baseline:0,workAtStart:0,workAdded:0,workRemoved:0,workCompleted:0,workRemaining:0,isForecast:!1,isActive:!1,issues:[]},{sprintId:1,sprintName:"Sprint 1",baseline:-5,workAtStart:0,workAdded:5,workRemoved:0,workCompleted:5,workRemaining:0,startTime:100,endTime:200,isForecast:!1,isActive:!1,issues:["TEST-1"]},{sprintId:2,sprintName:"Sprint 2",baseline:-26,workAtStart:0,workAdded:21,workRemoved:0,workCompleted:8,workRemaining:13,startTime:200,endTime:300,isForecast:!1,isActive:!1,issues:["TEST-2"]}]),deepEqual(t.snapshot,{workRemaining:13,estimatedIssueCount:3,issueCount:3,workCompleted:13,estimatableIssueCount:3})}),test("Sprints before work is started on a ScopeBurndown are not included",function(){var e={sprints:this.makeSprints(9),changes:{100:this.addAndEstimate("TEST-1",1),200:this.addAndEstimate("TEST-2",2),300:this.addAndEstimate("TEST-3",3),899:[this.moveToDone("TEST-1")]},labels:{originalEstimate:this.getOriginalEstimateSprintName()},estimatableIssueKeys:["TEST-1","TEST-2","TEST-3"]},t=this.service.getScopeBySprintData(e);deepEqual(t.sprints,[{sprintId:"original",sprintName:this.getOriginalEstimateSprintName(),baseline:0,workAtStart:6,workAdded:0,workRemoved:0,workCompleted:0,workRemaining:6,isForecast:!1,isActive:!1,issues:[]},{sprintId:8,sprintName:"Sprint 8",baseline:0,workAtStart:6,workAdded:0,workRemoved:0,workCompleted:1,workRemaining:5,startTime:800,endTime:900,isForecast:!1,isActive:!1,issues:["TEST-1"]},{sprintId:9,sprintName:"Sprint 9",baseline:0,workAtStart:5,workAdded:0,workRemoved:0,workCompleted:0,workRemaining:5,startTime:900,endTime:1e3,isForecast:!1,isActive:!1,issues:[]}])}),test("Sprints after work is completed on a ScopeBurndown are not included",function(){var e={sprints:this.makeSprints(9),changes:{100:this.addAndEstimate("TEST-1",1),899:[this.moveToDone("TEST-1")]},labels:{originalEstimate:this.getOriginalEstimateSprintName()},estimatableIssueKeys:["TEST-1"]},t=this.service.getScopeBySprintData(e);deepEqual(t.sprints,[{sprintId:"original",sprintName:this.getOriginalEstimateSprintName(),baseline:0,workAtStart:1,workAdded:0,workRemoved:0,workCompleted:0,workRemaining:1,isForecast:!1,isActive:!1,issues:[]},{sprintId:8,sprintName:"Sprint 8",baseline:0,workAtStart:1,workAdded:0,workRemoved:0,workCompleted:1,workRemaining:0,startTime:800,endTime:900,isForecast:!1,isActive:!1,issues:["TEST-1"]}])}),test("Issue added to ScopeBurndown when already done does affect scope",function(){var e={sprints:this.makeSprints(2),changes:{100:[this.moveToNotDone("TEST-1"),this.changeEstimate("TEST-1",1)],101:[this.moveToDone("TEST-1"),this.addToScopeBurndown("TEST-1")]},labels:{originalEstimate:this.getOriginalEstimateSprintName()},estimatableIssueKeys:["TEST-1"]},t=this.service.getScopeBySprintData(e);deepEqual(t.sprints,[{sprintId:"original",sprintName:this.getOriginalEstimateSprintName(),baseline:0,workAtStart:0,workAdded:0,workRemoved:0,workCompleted:0,workRemaining:0,isForecast:!1,isActive:!1,issues:[]},{baseline:-1,endTime:200,isActive:!1,isForecast:!1,issues:["TEST-1"],sprintId:1,sprintName:"Sprint 1",startTime:100,workAdded:1,workAtStart:0,workCompleted:1,workRemaining:0,workRemoved:0}])}),test("Issue added to ScopeBurndown and remove from ScopeBurndown multiple times does not affect scope multiple times",function(){var e={sprints:this.makeSprints(2),changes:{1:this.addAndEstimate("TEST-1",1),2:this.addAndEstimate("TEST-2",2),100:[this.moveToDone("TEST-1"),this.removeFromScopeBurndown("TEST-2"),this.addToScopeBurndown("TEST-2"),this.removeFromScopeBurndown("TEST-2"),this.addToScopeBurndown("TEST-2"),this.removeFromScopeBurndown("TEST-2")]},labels:{originalEstimate:this.getOriginalEstimateSprintName()},estimatableIssueKeys:["TEST-1","TEST-2"]},t=this.service.getScopeBySprintData(e);deepEqual(t.sprints,[{sprintId:"original",sprintName:this.getOriginalEstimateSprintName(),baseline:0,workAtStart:3,workAdded:0,workRemoved:0,workCompleted:0,workRemaining:3,isForecast:!1,isActive:!1,issues:[]},{baseline:2,endTime:200,isActive:!1,isForecast:!1,issues:["TEST-1"],sprintId:1,sprintName:"Sprint 1",startTime:100,workAdded:0,workAtStart:3,workCompleted:1,workRemaining:0,workRemoved:2}])}),test("Issue added to ScopeBurndown and move to done after that removed from ScopeBurndown does not affect scope",function(){var e={sprints:this.makeSprints(2),changes:{99:this.addAndEstimate("TEST-1",1),200:this.addAndEstimate("TEST-2",2),201:[this.moveToDone("TEST-2"),this.removeFromScopeBurndown("TEST-2")]},labels:{originalEstimate:this.getOriginalEstimateSprintName()},estimatableIssueKeys:["TEST-1","TEST-2"]},t=this.service.getScopeBySprintData(e);deepEqual(t.sprints,[{sprintId:"original",sprintName:this.getOriginalEstimateSprintName(),baseline:0,workAtStart:1,workAdded:0,workRemoved:0,workCompleted:0,workRemaining:1,isForecast:!1,isActive:!1,issues:[]},{baseline:0,endTime:300,isActive:!1,isForecast:!1,issues:[],sprintId:2,sprintName:"Sprint 2",startTime:200,workAdded:0,workAtStart:1,workCompleted:0,workRemaining:1,workRemoved:0}])}),test("Issue removed from ScopeBurndown when already done does not affect scope",function(){var e={sprints:this.makeSprints(3),changes:{100:this.addAndEstimate("TEST-1",1),101:this.addAndEstimate("TEST-2",2),200:[this.moveToDone("TEST-1")],300:[this.removeFromScopeBurndown("TEST-1")]},labels:{originalEstimate:this.getOriginalEstimateSprintName()},estimatableIssueKeys:["TEST-1","TEST-2"]},t=this.service.getScopeBySprintData(e);deepEqual(t.sprints,[{sprintId:"original",sprintName:this.getOriginalEstimateSprintName(),baseline:0,workAtStart:3,workAdded:0,workRemoved:0,workCompleted:0,workRemaining:3,isForecast:!1,isActive:!1,issues:[]},{sprintId:2,sprintName:"Sprint 2",baseline:0,workAtStart:3,workAdded:0,workRemoved:0,workCompleted:1,workRemaining:2,startTime:200,endTime:300,isForecast:!1,isActive:!1,issues:["TEST-1"]},{sprintId:3,sprintName:"Sprint 3",baseline:0,workAtStart:2,workAdded:0,workRemoved:0,workCompleted:0,workRemaining:2,startTime:300,endTime:400,isForecast:!1,isActive:!1,issues:[]}])}),test("Issue removed from ScopeBurndown when already done, but is later not done, and add it back to ScopeBurndown does affect scope",function(){var e={sprints:this.makeSprints(3),changes:{100:this.addAndEstimate("TEST-1",1),101:this.addAndEstimate("TEST-2",2),200:[this.moveToDone("TEST-1")],300:[this.removeFromScopeBurndown("TEST-1")],400:[this.moveToNotDone("TEST-1")],401:[this.addToScopeBurndown("TEST-1")]},labels:{originalEstimate:this.getOriginalEstimateSprintName()},estimatableIssueKeys:["TEST-1","TEST-2"]},t=this.service.getScopeBySprintData(e);deepEqual(t.sprints,[{sprintId:"original",sprintName:this.getOriginalEstimateSprintName(),baseline:0,workAtStart:3,workAdded:0,workRemoved:0,workCompleted:0,workRemaining:3,isForecast:!1,isActive:!1,issues:[]}])}),test("Issue removed from ScopeBurndown is ignored even if it is completed later",function(){var e={sprints:this.makeSprints(3),changes:{100:this.addAndEstimate("TEST-1",1),101:this.addAndEstimate("TEST-2",2),200:[this.moveToDone("TEST-1")],201:[this.removeFromScopeBurndown("TEST-2")],300:[this.moveToDone("TEST-2")]},labels:{originalEstimate:this.getOriginalEstimateSprintName()},estimatableIssueKeys:["TEST-1","TEST-2"]},t=this.service.getScopeBySprintData(e);deepEqual(t.sprints,[{sprintId:"original",sprintName:this.getOriginalEstimateSprintName(),baseline:0,workAtStart:3,workAdded:0,workRemoved:0,workCompleted:0,workRemaining:3,isForecast:!1,isActive:!1,issues:[]},{sprintId:2,sprintName:"Sprint 2",baseline:2,workAtStart:3,workAdded:0,workRemoved:2,workCompleted:1,workRemaining:0,startTime:200,endTime:300,isForecast:!1,isActive:!1,issues:["TEST-1"]}])}),test("Issues with estimates removed should be reflected in snapshot",function(){var e={sprints:[],changes:{1:this.addAndEstimate("TEST-1",1),100:[this.changeEstimate("TEST-1",void 0)]},estimatableIssueKeys:["TEST-1"]},t=this.service.getScopeBySprintData(e);deepEqual(t.snapshot,{workRemaining:0,estimatedIssueCount:0,issueCount:1,workCompleted:0,estimatableIssueCount:1})}),test("Average velocity is rounded for forecast",function(){var e={sprints:this.makeSprints(3),changes:{1:this.addAndEstimate("TEST-1",3),2:this.addAndEstimate("TEST-2",4),3:this.addAndEstimate("TEST-3",4),4:this.addAndEstimate("TEST-4",3),5:this.addAndEstimate("TEST-5",3),6:this.addAndEstimate("TEST-6",3),7:this.addAndEstimate("TEST-7",3),100:[this.moveToDone("TEST-1")],200:[this.moveToDone("TEST-2")],300:[this.moveToDone("TEST-3")]},estimatableIssueKeys:["TEST-1","TEST-2","TEST-3","TEST-4","TEST-5","TEST-6","TEST-7"]},t=this.service.getScopeBySprintData(e);strictEqual(t.forecast.velocity,4,"Velocity is rounded")}),test("No forecast is given if velocity rounds to 0",function(){var e={sprints:this.makeSprints(3),changes:{1:this.addAndEstimate("TEST-1",0),2:this.addAndEstimate("TEST-2",0),3:this.addAndEstimate("TEST-3",1),4:this.addAndEstimate("TEST-4",3),5:this.addAndEstimate("TEST-5",3),6:this.addAndEstimate("TEST-6",3),7:this.addAndEstimate("TEST-7",3),100:[this.moveToDone("TEST-1")],200:[this.moveToDone("TEST-2")],300:[this.moveToDone("TEST-3")]},estimatableIssueKeys:["TEST-1","TEST-2","TEST-3","TEST-4","TEST-5","TEST-6","TEST-7"]},t=this.service.getScopeBySprintData(e);ok(t.forecast.forecastError,"No forecast")}),test("No forecast is given if there are fewer than 3 completed sprints",function(){var e={sprints:this.makeSprints(3),changes:{1:this.addAndEstimate("TEST-1",0),2:this.addAndEstimate("TEST-2",0),3:this.addAndEstimate("TEST-3",1),4:this.addAndEstimate("TEST-4",3),5:this.addAndEstimate("TEST-5",3),6:this.addAndEstimate("TEST-6",3),7:this.addAndEstimate("TEST-7",3),100:[this.moveToDone("TEST-1")],200:[this.moveToDone("TEST-2")],300:[this.moveToDone("TEST-3")]},estimatableIssueKeys:["TEST-1","TEST-2","TEST-3","TEST-4","TEST-5","TEST-6","TEST-7"]};e.sprints[2].state="ACTIVE";var t=this.service.getScopeBySprintData(e);ok(t.forecast.forecastError,"No forecast")}),test("Active sprint is counted differently if work completed is less than average velocity",function(){var e={sprints:this.makeSprints(4),changes:{1:this.addAndEstimate("TEST-1",3),2:this.addAndEstimate("TEST-2",3),3:this.addAndEstimate("TEST-3",3),4:this.addAndEstimate("TEST-4",2),5:this.addAndEstimate("TEST-5",3),6:this.addAndEstimate("TEST-6",3),7:this.addAndEstimate("TEST-7",3),100:[this.moveToDone("TEST-1")],200:[this.moveToDone("TEST-2")],300:[this.moveToDone("TEST-3")],400:[this.moveToDone("TEST-4")]},estimatableIssueKeys:["TEST-1","TEST-2","TEST-3","TEST-4","TEST-5","TEST-6","TEST-7"]};e.sprints[3].state="ACTIVE";var t=this.service.getScopeBySprintData(e),i=t.forecast;strictEqual(_.last(t.sprints).workRemaining,9,"Last sprint's work remaining is actual"),strictEqual(i.velocity,3,"Velocity"),strictEqual(i.workRemaining,8,"Forecast's work remaining assumes work done in active sprint is equal to velocity"),strictEqual(i.isLastSprintForecast,!0)}),test("Active sprint is used in velocity calculation if work completed is greater than average velocity",function(){var e={sprints:this.makeSprints(4),changes:{1:this.addAndEstimate("TEST-1",1),2:this.addAndEstimate("TEST-2",3),3:this.addAndEstimate("TEST-3",5),4:this.addAndEstimate("TEST-4",5),5:this.addAndEstimate("TEST-5",3),6:this.addAndEstimate("TEST-6",3),7:this.addAndEstimate("TEST-7",1),100:[this.moveToDone("TEST-1")],200:[this.moveToDone("TEST-2")],300:[this.moveToDone("TEST-3")],400:[this.moveToDone("TEST-4")]},estimatableIssueKeys:["TEST-1","TEST-2","TEST-3","TEST-4","TEST-5","TEST-6","TEST-7"]};e.sprints[3].state="ACTIVE";var t=this.service.getScopeBySprintData(e),i=t.forecast;strictEqual(i.velocity,4,"Velocity is the average of last 3 sprints incl. the active one"),strictEqual(i.isLastSprintForecast,!1),strictEqual(_.last(t.sprints).workCompleted,5,"Work completed in active sprint is actual"),strictEqual(i.sprintsRemaining,2,"Only 2 forecast sprints given the new velocity")}),test("Correct work completed when average velocity is greater than remaining work in active sprint",function(){var e={sprints:this.makeSprints(4),changes:{1:this.addAndEstimate("TEST-1",3),2:this.addAndEstimate("TEST-2",3),3:this.addAndEstimate("TEST-3",3),4:this.addAndEstimate("TEST-4",1),100:[this.moveToDone("TEST-1")],200:[this.moveToDone("TEST-2")],300:[this.moveToDone("TEST-3")]},estimatableIssueKeys:["TEST-1","TEST-2","TEST-3","TEST-4"]};e.sprints[3].state="ACTIVE";var t=this.service.getScopeBySprintData(e),i=_.last(t.sprints);strictEqual(i.workCompleted,0),strictEqual(i.workRemaining,1),strictEqual(t.forecast.sprintsRemaining,0,"Even though no work is done in active sprint yet, we expect this to be the last")}),test("Work remaining in snapshot is based on actual work done in the active sprint",function(){var e={sprints:this.makeSprints(4),changes:{1:this.addAndEstimate("TEST-1",3),2:this.addAndEstimate("TEST-2",3),3:this.addAndEstimate("TEST-3",3),4:this.addAndEstimate("TEST-4",1),5:this.addAndEstimate("TEST-5",3),100:[this.moveToDone("TEST-1")],200:[this.moveToDone("TEST-2")],300:[this.moveToDone("TEST-3")],400:[this.moveToDone("TEST-4")]},estimatableIssueKeys:["TEST-1","TEST-2","TEST-3","TEST-4","TEST-5"]};e.sprints[3].state="ACTIVE";var t=this.service.getScopeBySprintData(e);strictEqual(t.snapshot.workRemaining,3,"Work remaining is correct")}),test("Zero baseline",function(){var e={sprints:this.makeSprints(3),changes:{1:this.addAndEstimate("TEST-1",3),100:[this.moveToDone("TEST-1")],101:this.addAndEstimate("TEST-2",3),200:[this.moveToDone("TEST-2")],201:this.addAndEstimate("TEST-3",3),300:[this.moveToDone("TEST-3")],301:this.addAndEstimate("TEST-4",3)},estimatableIssueKeys:["TEST-1","TEST-2","TEST-3","TEST-4"]},t=this.service.getScopeBySprintData(e,!0);strictEqual(t.sprints.length,4,"1 original estimate, 3 sprints"),strictEqual(_.all(t.sprints,function(e){return 0===e.baseline}),!0,"All sprints have a 0 baseline")}),test("Test duplicate change events do not create extra scope",function(){var e={sprints:this.makeSprints(1),changes:{1:this.addAndEstimate("TEST-1",1),100:[this.addToScopeBurndown("TEST-1")],101:[this.moveToDone("TEST-1")]},labels:{originalEstimate:this.getOriginalEstimateSprintName()},estimatableIssueKeys:["TEST-1"]},t=this.service.getScopeBySprintData(e);deepEqual(t.sprints,[{sprintId:"original",sprintName:this.getOriginalEstimateSprintName(),baseline:0,workAtStart:1,workAdded:0,workRemoved:0,workCompleted:0,workRemaining:1,isForecast:!1,isActive:!1,issues:[]},{sprintId:1,sprintName:"Sprint 1",baseline:0,workAtStart:1,workAdded:0,workRemoved:0,workCompleted:1,workRemaining:0,startTime:100,endTime:200,isForecast:!1,isActive:!1,issues:["TEST-1"]}])}),test("Test reopened issues are added correctly to the scope",function(){var e={sprints:this.makeSprints(1),changes:{1:this.addAndEstimate("TEST-1",1),100:[this.moveToDone("TEST-1")],101:[this.changeEstimate("TEST-2",1)],102:[this.moveToDone("TEST-2")],103:[this.moveToNotDone("TEST-2")],104:[this.addToScopeBurndown("TEST-2")]},labels:{originalEstimate:this.getOriginalEstimateSprintName()},estimatableIssueKeys:["TEST-1","TEST-2"]},t=this.service.getScopeBySprintData(e);deepEqual(t.sprints,[{sprintId:"original",sprintName:this.getOriginalEstimateSprintName(),baseline:0,workAtStart:1,workAdded:0,workRemoved:0,workCompleted:0,workRemaining:1,isForecast:!1,isActive:!1,issues:[]},{sprintId:1,sprintName:"Sprint 1",baseline:-1,workAtStart:1,workAdded:1,workRemoved:0,workCompleted:1,workRemaining:1,startTime:100,endTime:200,isForecast:!1,isActive:!1,issues:["TEST-1"]}])}),test("Test work done before first sprint",function(){var e={sprints:this.makeSprints(2),changes:{1:this.addAndEstimate("TEST-1",1),2:[this.moveToDone("TEST-1")],100:this.addAndEstimate("TEST-2",1),101:[this.moveToDone("TEST-2")]},labels:{originalEstimate:this.getOriginalEstimateSprintName()},estimatableIssueKeys:["TEST-1","TEST-2"]},t=this.service.getScopeBySprintData(e);deepEqual(t.sprints,[{sprintId:"original",sprintName:this.getOriginalEstimateSprintName(),baseline:0,workAtStart:1,workAdded:0,workRemoved:0,workCompleted:1,workRemaining:0,isForecast:!1,isActive:!1,issues:["TEST-1"]},{sprintId:1,sprintName:"Sprint 1",baseline:-1,workAtStart:0,workAdded:1,workRemoved:0,workCompleted:1,workRemaining:0,startTime:100,endTime:200,isForecast:!1,isActive:!1,issues:["TEST-2"]}])}),test("Test estimated issues calculation",function(){var e={sprints:this.makeSprints(3),changes:{1:[this.moveToNotDone("TEST-1"),this.moveToNotDone("TEST-2"),this.moveToNotDone("TEST-3")],3:[this.changeEstimate("TEST-2",3)],10:[this.addToScopeBurndown("TEST-1"),this.addToScopeBurndown("TEST-2"),this.addToScopeBurndown("TEST-3")],100:[this.moveToDone("TEST-1")],200:[this.moveToDone("TEST-2")],299:[this.moveToNotDone("TEST-4"),this.addToScopeBurndown("TEST-4"),this.changeEstimate("TEST-4",8)],300:[this.moveToDone("TEST-3")]},labels:{originalEstimate:this.getOriginalEstimateSprintName()},estimatableIssueKeys:["TEST-2","TEST-4"]},t=this.service.getScopeBySprintData(e);deepEqual(t.snapshot,{workRemaining:8,estimatedIssueCount:2,estimatableIssueCount:2,issueCount:4,workCompleted:3})}),test("Estimatable count should only take into account issues in the version, e.g. have not been removed",function(){var e={sprints:this.makeSprints(3),changes:{1:[this.moveToNotDone("TEST-1"),this.moveToNotDone("TEST-2"),this.moveToNotDone("TEST-3")],3:[this.changeEstimate("TEST-2",3)],10:[this.addToScopeBurndown("TEST-1"),this.addToScopeBurndown("TEST-2"),this.addToScopeBurndown("TEST-3")]},labels:{originalEstimate:this.getOriginalEstimateSprintName()},estimatableIssueKeys:["TEST-1","TEST-2","TEST-3","TEST-5"]},t=this.service.getScopeBySprintData(e);deepEqual(t.snapshot,{workRemaining:3,estimatedIssueCount:1,estimatableIssueCount:3,issueCount:3,workCompleted:0})}),test("Test unestimated issue count in epic",function(){var e={sprints:this.makeSprints(1),changes:{1:[this.moveToNotDone("TEST-1"),this.changeEstimate("TEST-1",8),this.moveToNotDone("TEST-2"),this.addToScopeBurndown("TEST-1"),this.addToScopeBurndown("TEST-2")],100:[this.moveToDone("TEST-1")]},estimatableIssueKeys:["TEST-1","TEST-2"]},t=this.service.getScopeBySprintData(e);strictEqual(t.forecast.remainingEstimatableIssueCount,1,"There should only be 1 estimable issue left in the scope")}),test("Test issues that are not estimatable are not counted",function(){var e={sprints:this.makeSprints(3),changes:{1:this.addAndEstimate("TEST-1",10),2:this.addAndEstimate("TEST-2",20),3:this.addAndEstimate("TEST-3",30),4:this.addAndEstimate("TEST-4",40),5:this.addAndEstimate("TEST-5",50),6:this.addAndEstimate("TEST-6",60),100:[this.moveToDone("TEST-1"),this.moveToDone("TEST-2")],200:[this.moveToDone("TEST-4")],300:[this.moveToDone("TEST-5")]},labels:{originalEstimate:this.getOriginalEstimateSprintName()},estimatableIssueKeys:["TEST-1","TEST-3","TEST-5"]},t=this.service.getScopeBySprintData(e);deepEqual(t.sprints[0],{sprintId:"original",sprintName:this.getOriginalEstimateSprintName(),baseline:0,workAtStart:90,workAdded:0,workRemoved:0,workCompleted:0,workRemaining:90,isForecast:!1,isActive:!1,issues:[]},"the work remaining should be the total of TEST-1, TEST-3 and TEST-5's estimates."),deepEqual(t.sprints[1],{sprintId:1,sprintName:"Sprint 1",baseline:0,workAtStart:90,workAdded:0,workRemoved:0,workCompleted:10,workRemaining:80,startTime:100,endTime:200,isForecast:!1,isActive:!1,issues:["TEST-1","TEST-2"]}),deepEqual(t.sprints[2],{sprintId:2,sprintName:"Sprint 2",baseline:0,workAtStart:80,workAdded:0,workRemoved:0,workCompleted:0,workRemaining:80,startTime:200,endTime:300,isForecast:!1,isActive:!1,issues:["TEST-4"]}),deepEqual(t.sprints[3],{sprintId:3,sprintName:"Sprint 3",baseline:0,workAtStart:80,workAdded:0,workRemoved:0,workCompleted:50,workRemaining:30,startTime:300,endTime:400,isForecast:!1,isActive:!1,issues:["TEST-5"]}),deepEqual(t.forecast,{sprintsRemaining:2,workRemaining:30,velocity:20,baseline:0,isLastSprintForecast:!1}),strictEqual(t.snapshot.workCompleted,60),strictEqual(t.snapshot.workRemaining,30),strictEqual(t.snapshot.issueCount,6),strictEqual(t.snapshot.estimatableIssueCount,3),strictEqual(t.snapshot.estimatedIssueCount,3)}),test("Test unestimated issue count in epic when remaining issues are not estimatable",function(){var e={sprints:this.makeSprints(1),changes:{1:[this.moveToNotDone("TEST-1"),this.changeEstimate("TEST-1",8),this.moveToNotDone("TEST-2"),this.addToScopeBurndown("TEST-1"),this.addToScopeBurndown("TEST-2")],100:[this.moveToDone("TEST-1")]},estimatableIssueKeys:["TEST-1"]},t=this.service.getScopeBySprintData(e);strictEqual(t.forecast.remainingEstimatableIssueCount,0,"Only remaining issue is not estimatable")}),test("Test values are accurate if only remaining issues are not estimatable",function(){var e={sprints:this.makeSprints(3),changes:{1:this.addAndEstimate("TEST-1",10),2:this.addAndEstimate("TEST-2",20),3:this.addAndEstimate("TEST-3",30),4:this.addAndEstimate("TEST-4",40),5:this.addAndEstimate("TEST-5",50),6:this.addAndEstimate("TEST-6",60),7:this.addAndEstimate("TEST-7",70),100:[this.moveToDone("TEST-1")],200:[this.moveToDone("TEST-2")],300:[this.moveToDone("TEST-3")]},estimatableIssueKeys:["TEST-1","TEST-2","TEST-3"]},t=this.service.getScopeBySprintData(e),i=t.forecast;strictEqual(_.last(t.sprints).workRemaining,0,"Last sprint's work remaining is actual"),deepEqual(t.snapshot,{workRemaining:0,workCompleted:60,estimatedIssueCount:3,estimatableIssueCount:3,issueCount:7},"All estimatable work is completed"),strictEqual(i.remainingEstimatableIssueCount,0,"No estimatable issue count when no work remaining"),strictEqual(typeof i.workRemaining,"undefined","No work remaining when no remaining estimatable issues"),strictEqual(typeof i.velocity,"undefined","No velocity when no remaining estimatable issues"),strictEqual(typeof i.isLastSprintForecast,"undefined","No last sprint forecast when no remaining estimatable issues")}),test("Test values are accurate if only remaining issues are unestimated or not estimatable",function(){var e={sprints:this.makeSprints(4),changes:{1:this.addAndEstimate("TEST-1",10),2:this.addAndEstimate("TEST-2",20),3:this.addAndEstimate("TEST-3",30),4:this.addAndEstimate("TEST-4",40),5:this.addAndEstimate("TEST-5",50),6:this.addAndEstimate("TEST-6"),7:this.addAndEstimate("TEST-7"),100:[this.moveToDone("TEST-1")],200:[this.moveToDone("TEST-2")],300:[this.moveToDone("TEST-3")],400:[this.moveToDone("TEST-4")]},estimatableIssueKeys:["TEST-1","TEST-2","TEST-3","TEST-6","TEST-7"]};e.sprints[3].state="ACTIVE";var t=this.service.getScopeBySprintData(e),i=t.forecast;strictEqual(_.last(t.sprints).workRemaining,0,"Last sprint's work remaining is actual"),deepEqual(t.snapshot,{workRemaining:0,workCompleted:60,estimatedIssueCount:3,estimatableIssueCount:5,issueCount:7},"All estimatable work except TEST-6 and TEST-7 is completed"),strictEqual(i.remainingEstimatableIssueCount,2,"TEST-6 and TEST-7 are estimatable but unestimated"),strictEqual(typeof i.workRemaining,"undefined","No work remaining since TEST-6 and TEST-7 are unestimated"),strictEqual(typeof i.velocity,"undefined","No velocity when no work remaining"),strictEqual(typeof i.isLastSprintForecast,"undefined","No last sprint forecast when no work remaining")})});