/**
 * Displays a dialog relating to an issue or cluster of issues.
 */

GH.Reports = GH.Reports || {};

GH.Reports.BurnupChartDialog = (function() {
    var DIALOG_ID = 'sprint-burnup-issue';
    var SCROLL_CONTAINER = '#ghx-report-scrollarea > .aui-page-panel';
    var dialog;

    GH.InlineDialog.preventCloseOnClick(DIALOG_ID);

    function renderEvent(chartmodel, event) {
        var fmt = chartmodel.formatStatistic;

        if (event.change.key) {
            var delta = event.change.toValue - event.change.fromValue;

            return GH.tpl.reports.burnupReport.renderDialogIssueContent({
                issueKey: event.change.key,
                issueSummary: chartmodel.issueToSummary[event.change.key],
                fromValue: fmt(event.change.fromValue),
                toValue: fmt(event.change.toValue),
                totalFromValue: fmt(event.value - delta),
                totalToValue: fmt(event.value),
                eventDescription: chartmodel.formatEventType(event.change.type)
            });
        }

        return GH.tpl.reports.burnupReport.renderDialogContent({
            totalValue: event.value,
            statistic: chartmodel.statisticField.name
        });
    }

    function show(trigger, chartmodel, event) {

        // use d3 to manipulate the classes since jQuery/ie don't support addClass/classList for svg elements.
        var triggerElement = d3.select(trigger);
        triggerElement.classed('active', true);

        dialog = GH.SideInlineDialog.create(DIALOG_ID, trigger, function($content, $trigger, showPopup) {
            $content.closest('.aui-inline-dialog').addClass('ghx-inline-dialog');
            $content.html(renderEvent(chartmodel, event));
            showPopup();
        }, {
            addActiveClass: false,
            container: SCROLL_CONTAINER,
            fadeTime: 0,
            noBind: true,
            cacheContent: false, // don't cache the dialog content
            hideDelay: 60000, // set longer timeout (default is 10 seconds)
            persistent: true,
            hideCallback: function() {
                triggerElement.classed('active', false);
            }
        });
        dialog.show();

        return dialog;
    }

    function isVisible() {
        return dialog ? dialog.is(":visible") : false;
    }

    return {
        /**
         * Create and show a dialog for an issue or cluster of issues
         *
         * @param {Element} trigger - element to position the dialog next to
         * @param {issue[]|issue} issues - renders different content depending on whether
         * a single issue or an array of issues are passed
         * @return {InlineDialog}
         */
        show: show,
        /**
         * Hides dialog if it is showing
         */
        hide: function() {
            if (dialog) {
                dialog.hide();
            }
        },
        /**
         * Test if there is an instance of this dialog already visible.
         */
        isVisible: isVisible
    };
})();