GH.Reports = GH.Reports || {};
GH.Reports.controlChartLegend = function() {
    var lineData = [ [0, 0], [1, 1] ];
    var issue = function(selection) {
        selection
            .append('circle')
            .attr('cx', '50%')
            .attr('cy', '50%')
            .attr('r', 4)
            .classed('issue', true);
    };
    var cluster = function(selection) {
        selection
            .append('circle')
            .attr('cx', '50%')
            .attr('cy', '50%')
            .attr('r', 9)
            .classed('cluster', true);
    };
    var average = c3.linePlot()
        .data(lineData)
        .elementClass('control-chart-mean');
    var rollingAverage = c3.linePlot()
        .data(lineData)
        .elementClass('control-chart-aggregate-mean');
    var standardDeviation = function(selection) {
        selection
            .append('rect')
            .attr('width', '100%')
            .attr('height', '100%')
            .classed('standard-deviation', true);
    };

    return c3.component('controlChartLegend')
        .extend(GH.Reports.multipleCharts())
        .charts([
            issue,
            cluster,
            average,
            rollingAverage,
            standardDeviation
        ]);
};
