/**
 * Represents the selection of viewing options for the control chart:
 * - non-working days
 */
(function() {

    var DEFAULT_NWD_SETTING = false;

    /**
     * @constructor
     */
    function ControlChartViewingOptionsModel() {}

    ControlChartViewingOptionsModel.prototype = {
        /**
         * Boolean indicating if non-working days should be included in cycle time calculations.
         *
         * @type {boolean}
         */
        includeNonWorkingDays: DEFAULT_NWD_SETTING,

        /**
         * Reset the model to the default state.
         *
         * @returns {ControlChartViewingOptionsModel}
         */
        resetToDefaults: function() {
            this.includeNonWorkingDays = DEFAULT_NWD_SETTING;
            return this;
        },

        /**
         * Updates the model from the normalized setting stored in board state.
         *
         * @param {object} normalized
         * @returns {ControlChartViewingOptionsModel}
         */
        fromNormalized: function(normalized) {
            if ('includeNonWorkingDays' in normalized) {
                this.includeNonWorkingDays = normalized.includeNonWorkingDays;
            } else {
                this.resetToDefaults();
            }

            return this;
        },

        /**
         * Normalizes the model to the setting string expected by board state.
         *
         * @returns {{includeNonWorkingDays: boolean}}
         */
        toNormalized: function() {
            var normalized = {};

            if (this.includeNonWorkingDays) {
                normalized.includeNonWorkingDays = this.includeNonWorkingDays;
            }

            return normalized;
        },

        /**
         * Tests if the currently selected items on the model match the default state.
         *
         * @returns {boolean}
         */
        isDefault: function() {
            return (this.includeNonWorkingDays === DEFAULT_NWD_SETTING);
        }
    };

    GH.Reports.ControlChartViewingOptionsModel = ControlChartViewingOptionsModel;
}());