GH.Reports.ControlChartViewingOptionsView = (function (jq) {
    var model = null;
    var previousModelNormalized = null;
    var handler = jq.noop;
    var $nwdCheckbox;
    var $resetBtn;
    var isEventFromUI = true;


    /**
     * Initialise the controlls and events required for this view
     * @param {jQuery} $rootElement jQuery object containing the DOM elements for the view
     */
    function domInit($rootElement) {

        // Parent controller doesn't destroy subs on hide, so reset model or we don't register a change worth rendering
        previousModelNormalized = null;

        $nwdCheckbox = $rootElement.find('#js-option-nwd').on('change', function () {
            if (isEventFromUI) {
                // Update data model
                model.includeNonWorkingDays = this.checked;
                digestModel();
            }
        });

        // Reset link button
        $resetBtn = $rootElement.find('.js-reset-btn').on('click', function (e) {
            e.preventDefault();
            resetToDefault();
        });
    }


    /**
     * Checks for model changes, syncs model to UI and raises change event
     * @private
     */
    function digestModel() {
        if (!_.isEqual(model.toNormalized(), previousModelNormalized)) {
            // Don't trigger modelChanged if model is being initialized
            if (previousModelNormalized !== null) {
                handler('modelChanged');
            }
            syncComponents();
            previousModelNormalized = model.toNormalized();
        }
    }


    /**
     * Renders model state to UI components
     * @private
     */
    function syncComponents() {
        // deactivates event handlers
        isEventFromUI = false;

        // Non-working days
        $nwdCheckbox.prop('checked', model.includeNonWorkingDays);

        // Toggle reset button
        if (model.isDefault()) {
            $resetBtn.attr('aria-disabled', 'true');
        } else {
            $resetBtn.removeAttr('aria-disabled');
        }

        // reactivate event handlers
        isEventFromUI = true;
    }


    /**
     * Ask the controller to reset the model to the default selections
     */
    function resetToDefault() {
        handler('resetToDefaults');
    }


    return {
        /**
         * Initialise the view for the first time
         */
        start: function (settings) {
            model = settings;
            domInit(jq('#ghx-controlchart-viewing-options'));
        },

        /**
         * Check if the view model has changed and sync UI components
         */
        digest: function () {
            digestModel();
        },

        /**
         * Bind handler methods from the controller to the view
         * @param {Function} delegate Handler method exposed by controller
         */
        setHandler: function (delegate) {
            handler = delegate;
        },

        /**
         * Return the view model
         * @returns {String}
         */
        getModel: function () {
            return model;
        }
    };

}(AJS.$));